/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.EntryFactoryImpl;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.NonTransactionalInvocationContextContainer;
import org.infinispan.context.TransactionalInvocationContextContainer;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.util.Util;

@DefaultFactoryFor(classes={CacheNotifier.class, CommandsFactory.class, CacheLoaderManager.class, InvocationContextContainer.class, PassivationManager.class, BatchContainer.class, TransactionLog.class, EvictionManager.class, InvocationContextContainer.class, TransactionCoordinator.class, RecoveryAdminOperations.class, StateTransferLock.class, ClusteringDependentLogic.class})
public class EmptyConstructorNamedCacheFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (componentType.isInterface()) {
            if (componentType.equals(ClusteringDependentLogic.class)) {
                if (this.configuration.getCacheMode().isReplicated() || !this.configuration.getCacheMode().isClustered() || this.configuration.getCacheMode().isInvalidation()) {
                    return componentType.cast(new ClusteringDependentLogic.AllNodesLogic());
                }
                return componentType.cast(new ClusteringDependentLogic.DistributionLogic());
            }
            if (componentType.equals(StreamingMarshaller.class)) {
                VersionAwareMarshaller versionAwareMarshaller = Util.getInstance(VersionAwareMarshaller.class);
                return componentType.cast(versionAwareMarshaller);
            }
            if (componentType.equals(EntryFactory.class)) {
                return componentType.cast(Util.getInstance(EntryFactoryImpl.class));
            }
            if (componentType.equals(InvocationContextContainer.class)) {
                Class componentImpl = this.configuration.isTransactionalCache() ? TransactionalInvocationContextContainer.class : NonTransactionalInvocationContextContainer.class;
                return componentType.cast(Util.getInstance(componentImpl));
            }
            Class componentImpl = Util.loadClass(componentType.getName() + "Impl", this.configuration.getClassLoader());
            return componentType.cast(Util.getInstance(componentImpl));
        }
        return Util.getInstance(componentType);
    }
}

