/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.synchronization;

import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.config.Configuration;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.AbstractEnlistmentAdapter;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SynchronizationAdapter
extends AbstractEnlistmentAdapter
implements Synchronization {
    private static final Log log = LogFactory.getLog(SynchronizationAdapter.class);
    private final LocalTransaction localTransaction;
    private final TransactionCoordinator txCoordinator;

    public SynchronizationAdapter(LocalTransaction localTransaction, TransactionCoordinator txCoordinator, CommandsFactory commandsFactory, RpcManager rpcManager, TransactionTable transactionTable, ClusteringDependentLogic clusteringLogic, Configuration configuration) {
        super(localTransaction, commandsFactory, rpcManager, transactionTable, clusteringLogic, configuration);
        this.localTransaction = localTransaction;
        this.txCoordinator = txCoordinator;
    }

    public void beforeCompletion() {
        if (log.isTraceEnabled()) {
            log.tracef("beforeCompletion called for %s", this.localTransaction);
        }
        try {
            this.txCoordinator.prepare(this.localTransaction);
        }
        catch (XAException e) {
            throw new CacheException("Could not prepare. ", e);
        }
    }

    public void afterCompletion(int status) {
        if (log.isTraceEnabled()) {
            log.tracef("afterCompletion(%s) called for %s.", status, this.localTransaction);
        }
        if (status == 3) {
            try {
                this.txCoordinator.commit(this.localTransaction, false);
            }
            catch (XAException e) {
                throw new CacheException("Could not commit.", e);
            }
        } else if (status == 4) {
            try {
                this.txCoordinator.rollback(this.localTransaction);
            }
            catch (XAException e) {
                throw new CacheException("Could not commit.", e);
            }
        } else {
            throw new IllegalArgumentException("Unknown status: " + status);
        }
        this.releaseLocksForCompletedTransaction(this.localTransaction);
    }

    public String toString() {
        return "SynchronizationAdapter{localTransaction=" + this.localTransaction + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynchronizationAdapter that = (SynchronizationAdapter)o;
        return !(this.localTransaction != null ? !this.localTransaction.equals(that.localTransaction) : that.localTransaction != null);
    }
}

