/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.jboss.as.ee.deployment.spi.JBossTarget;
import org.jboss.as.ee.deployment.spi.JBossTargetModuleID;

final class TargetModuleIDImpl
implements JBossTargetModuleID {
    private final JBossTarget target;
    private final String moduleID;
    private final TargetModuleID parentModuleID;
    private final ModuleType moduleType;
    private List<TargetModuleID> childModuleIDs = new ArrayList<TargetModuleID>();
    private boolean isRunning;

    TargetModuleIDImpl(JBossTarget target, String moduleID, TargetModuleID parentModuleID, ModuleType moduleType) {
        if (target == null) {
            throw new IllegalArgumentException("Null target");
        }
        if (moduleID == null) {
            throw new IllegalArgumentException("Null moduleID");
        }
        if (moduleType == null) {
            throw new IllegalArgumentException("Null moduleType");
        }
        this.target = target;
        this.moduleID = moduleID;
        this.parentModuleID = parentModuleID;
        this.moduleType = moduleType;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public ModuleType getModuleType() {
        return this.moduleType;
    }

    void addChildTargetModuleID(TargetModuleID childModuleID) {
        this.childModuleIDs.add(childModuleID);
    }

    public Target getTarget() {
        return this.target;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public String getWebURL() {
        return null;
    }

    public TargetModuleID getParentTargetModuleID() {
        return this.parentModuleID;
    }

    public TargetModuleID[] getChildTargetModuleID() {
        TargetModuleID[] idarr = new TargetModuleID[this.childModuleIDs.size()];
        this.childModuleIDs.toArray(idarr);
        return idarr;
    }

    public int hashCode() {
        String hashStr = this.moduleType + this.moduleID;
        if (this.parentModuleID != null) {
            hashStr = hashStr + this.parentModuleID.getModuleID();
        }
        return hashStr.hashCode();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof TargetModuleIDImpl) {
            TargetModuleIDImpl other = (TargetModuleIDImpl)obj;
            boolean bl = equals = this.moduleType.equals(other.moduleType) && this.moduleID.equals(other.moduleID);
            if (equals && this.parentModuleID != null) {
                equals = equals && this.parentModuleID.equals(other.parentModuleID);
            }
        }
        return equals;
    }

    public String toString() {
        String parentID = this.parentModuleID != null ? this.parentModuleID.getModuleID() : null;
        return "[target=" + this.target.getName() + ",parent=" + parentID + ",type=" + this.moduleType + ",id=" + this.moduleID + "]";
    }
}

