/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.Locale;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class CacheConfigOperationHandlers {
    static final OperationStepHandler LOCKING_ADD = new BasicCacheConfigAdd(CommonAttributes.LOCKING_ATTRIBUTES){

        @Override
        public void process(ModelNode submodel, ModelNode operation) {
        }
    };
    static final SelfRegisteringAttributeHandler LOCKING_ATTR = new AttributeWriteHandler(CommonAttributes.LOCKING_ATTRIBUTES);
    static final OperationStepHandler TRANSACTION_ADD = new BasicCacheConfigAdd(CommonAttributes.TRANSACTION_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler TRANSACTION_ATTR = new AttributeWriteHandler(CommonAttributes.TRANSACTION_ATTRIBUTES);
    static final OperationStepHandler EVICTION_ADD = new BasicCacheConfigAdd(CommonAttributes.EVICTION_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler EVICTION_ATTR = new AttributeWriteHandler(CommonAttributes.EVICTION_ATTRIBUTES);
    static final OperationStepHandler EXPIRATION_ADD = new BasicCacheConfigAdd(CommonAttributes.EXPIRATION_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler EXPIRATION_ATTR = new AttributeWriteHandler(CommonAttributes.EXPIRATION_ATTRIBUTES);
    static final OperationStepHandler STATE_TRANSFER_ADD = new BasicCacheConfigAdd(CommonAttributes.STATE_TRANSFER_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler STATE_TRANSFER_ATTR = new AttributeWriteHandler(CommonAttributes.STATE_TRANSFER_ATTRIBUTES);
    static final OperationStepHandler REHASHING_ADD = new BasicCacheConfigAdd(CommonAttributes.REHASHING_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler REHASHING_ATTR = new AttributeWriteHandler(CommonAttributes.REHASHING_ATTRIBUTES);
    static final OperationStepHandler STORE_ADD = new BasicCacheConfigAdd(CommonAttributes.STORE_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler STORE_ATTR = new AttributeWriteHandler(CommonAttributes.STORE_ATTRIBUTES);
    static final OperationStepHandler REMOVE = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.removeResource(PathAddress.EMPTY_ADDRESS);
            CacheConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler STORE_PROPERTY_ADD = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            CommonAttributes.VALUE.validateAndSet(operation, resource.getModel());
            CacheConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler STORE_PROPERTY_ATTR = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            CommonAttributes.VALUE.validateAndSet(operation, resource.getModel());
            CacheConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };

    static ModelNode createOperation(AttributeDefinition[] attributes, ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }

    static void reloadRequiredStep(OperationContext context) {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress elementAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
                    PathAddress cacheAddress = elementAddress.subAddress(0, elementAddress.size() - 1);
                    PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 2);
                    String cacheName = cacheAddress.getLastElement().getValue();
                    String containerName = containerAddress.getLastElement().getValue();
                    ServiceName cacheConfigurationServiceName = CacheConfigurationService.getServiceName(containerName, cacheName);
                    ServiceController controller = context.getServiceRegistry(false).getService(cacheConfigurationServiceName);
                    if (controller != null) {
                        context.reloadRequired();
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static class AttributeWriteHandler
    extends ReloadRequiredWriteAttributeHandler
    implements SelfRegisteringAttributeHandler {
        final AttributeDefinition[] attributes;

        private AttributeWriteHandler(AttributeDefinition[] attributes) {
            super(attributes);
            this.attributes = attributes;
        }

        @Override
        public void registerAttributes(ManagementResourceRegistration registry) {
            EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
            for (AttributeDefinition attr : this.attributes) {
                registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)this, flags);
            }
        }
    }

    static interface SelfRegisteringAttributeHandler
    extends OperationStepHandler {
        public void registerAttributes(ManagementResourceRegistration var1);
    }

    private static class BasicCacheConfigAdd
    implements OperationStepHandler,
    DescriptionProvider {
        private final AttributeDefinition[] attributes;

        BasicCacheConfigAdd(AttributeDefinition[] attributes) {
            this.attributes = attributes;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            ModelNode subModel = resource.getModel();
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, subModel);
            }
            this.process(subModel, operation);
            if (operation.hasDefined("property")) {
                for (Property property : operation.get("property").asPropertyList()) {
                    Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                    ModelNode value = property.getValue();
                    if (!value.isDefined()) {
                        throw new OperationFailedException(new ModelNode().set("property " + property.getName() + " not defined"));
                    }
                    param.getModel().get("value").set(value);
                }
            }
            CacheConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }

        void process(ModelNode subModel, ModelNode operation) {
        }

        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode().set("description");
        }
    }
}

