/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerWriteAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.Logger;

public class CacheContainerReadAttributeHandler
implements OperationStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheContainerReadAttributeHandler.class.getPackage().getName());
    public static final CacheContainerReadAttributeHandler INSTANCE = new CacheContainerReadAttributeHandler();
    private final ParametersValidator nameValidator = new ParametersValidator();
    private final Map<String, AttributeDefinition> attributeDefinitions;

    private CacheContainerReadAttributeHandler() {
        this(CommonAttributes.CACHE_CONTAINER_ATTRIBUTES);
    }

    private CacheContainerReadAttributeHandler(AttributeDefinition ... definitions) {
        assert (definitions != null) : ControllerMessages.MESSAGES.nullVar("definitions").getLocalizedMessage();
        this.nameValidator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.attributeDefinitions = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : definitions) {
            this.attributeDefinitions.put(def.getName(), def);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.nameValidator.validate(operation);
        String attributeName = operation.require("name").asString();
        ModelNode submodel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode currentValue = submodel.get(attributeName).clone();
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(attributeName);
        if (attributeDefinition.getName().equals(CommonAttributes.ALIAS.getName())) {
            String listAsString = this.convertListToString(attributeDefinition.getName(), currentValue);
            context.getResult().set(listAsString);
        } else {
            context.getResult().set(currentValue);
        }
        context.completeStep();
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
        for (AttributeDefinition attr : CommonAttributes.CACHE_CONTAINER_ATTRIBUTES) {
            registry.registerReadWriteAttribute(attr.getName(), (OperationStepHandler)this, (OperationStepHandler)CacheContainerWriteAttributeHandler.INSTANCE, flags);
        }
    }

    protected AttributeDefinition getAttributeDefinition(String attributeName) {
        return this.attributeDefinitions == null ? null : this.attributeDefinitions.get(attributeName);
    }

    private String convertListToString(String name, ModelNode value) {
        if (value.getType() == ModelType.UNDEFINED) {
            return "";
        }
        assert (value.getType() == ModelType.LIST) : ControllerMessages.MESSAGES.validationFailed(name);
        StringBuilder result = new StringBuilder();
        List list = value.asList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result.append(((ModelNode)list.get(i)).asString());
            if (i >= size - 1) continue;
            result.append(",");
        }
        return result.toString();
    }
}

