/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class CacheService<K, V>
implements Service<Cache<K, V>> {
    private final InjectedValue<CacheContainer> container = new InjectedValue();
    private final String name;
    private volatile Cache<K, V> cache;

    public static ServiceName getServiceName(String container, String cache) {
        return EmbeddedCacheManagerService.getServiceName(container).append(new String[]{cache != null ? cache : "___defaultcache"});
    }

    public CacheService(String name) {
        this.name = name;
    }

    public Cache<K, V> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.cache;
    }

    public Injector<CacheContainer> getCacheContainerInjector() {
        return this.container;
    }

    public CacheContainer getCacheContainer() {
        return (CacheContainer)this.container.getValue();
    }

    public void start(StartContext context) throws StartException {
        CacheContainer container = this.getCacheContainer();
        this.cache = container.getCache(this.name);
        this.cache.start();
    }

    public void stop(StopContext context) {
        this.cache.stop();
    }
}

