/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheAdd;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class DistributedCacheAdd
extends ClusteredCacheAdd {
    static final DistributedCacheAdd INSTANCE = new DistributedCacheAdd();

    static ModelNode createOperation(ModelNode address, ModelNode model) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        INSTANCE.populateMode(model, operation);
        INSTANCE.populate(model, operation);
        return operation;
    }

    private DistributedCacheAdd() {
        super(Configuration.CacheMode.DIST_SYNC);
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) {
        super.populate(fromModel, toModel);
        if (fromModel.hasDefined("owners")) {
            toModel.get("owners").set(fromModel.get("owners"));
        }
        if (fromModel.hasDefined("virtual-nodes")) {
            toModel.get("virtual-nodes").set(fromModel.get("virtual-nodes"));
        }
        if (fromModel.hasDefined("l1-lifespan")) {
            toModel.get("l1-lifespan").set(fromModel.get("l1-lifespan"));
        }
    }

    @Override
    void processModelNode(ModelNode cache, Configuration configuration, List<CacheAdd.AdditionalDependency<?>> additionalDeps) {
        super.processModelNode(cache, configuration, additionalDeps);
        FluentConfiguration fluent = configuration.fluent();
        if (cache.hasDefined("owners")) {
            fluent.hash().numOwners(Integer.valueOf(cache.get("owners").asInt()));
        }
        if (cache.hasDefined("virtual-nodes")) {
            fluent.hash().numVirtualNodes(Integer.valueOf(cache.get("virtual-nodes").asInt()));
        }
        if (cache.hasDefined("l1-lifespan")) {
            long lifespan = cache.get("l1-lifespan").asLong();
            if (lifespan > 0L) {
                fluent.l1().lifespan(Long.valueOf(lifespan));
            } else {
                fluent.l1().disable();
            }
        }
        if (cache.hasDefined("singleton") && cache.get(new String[]{"singleton", "rehashing"}).isDefined()) {
            ModelNode rehashing = cache.get(new String[]{"singleton", "rehashing"});
            FluentConfiguration.HashConfig fluentHash = fluent.hash();
            if (rehashing.hasDefined("enabled")) {
                fluentHash.rehashEnabled(Boolean.valueOf(rehashing.get("enabled").asBoolean()));
            }
            if (rehashing.hasDefined("timeout")) {
                fluentHash.rehashRpcTimeout(Long.valueOf(rehashing.get("timeout").asLong()));
            }
            if (rehashing.hasDefined("wait")) {
                fluentHash.rehashWait(Long.valueOf(rehashing.get("wait").asLong()));
            }
        }
    }
}

