/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.CacheConfigOperationHandlers;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAdd;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemAdd;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.TransportAdd;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class InfinispanSubsystemDescribe
implements OperationStepHandler {
    public static final InfinispanSubsystemDescribe INSTANCE = new InfinispanSubsystemDescribe();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode result = context.getResult();
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode subModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        result.add(InfinispanSubsystemAdd.createOperation(rootAddress.toModelNode(), subModel));
        if (subModel.hasDefined("cache-container")) {
            for (Property container : subModel.get("cache-container").asPropertyList()) {
                ModelNode containerAddress = rootAddress.toModelNode();
                containerAddress.add("cache-container", container.getName());
                result.add(CacheContainerAdd.createOperation(containerAddress, container.getValue()));
                this.addCacheContainerConfigCommands(container, containerAddress, result);
                for (Property cacheTypeList : container.getValue().asPropertyList()) {
                    ModelNode cacheAddress;
                    if (cacheTypeList.getName().equals("local-cache")) {
                        for (Property cache : cacheTypeList.getValue().asPropertyList()) {
                            cacheAddress = containerAddress.clone();
                            cacheAddress.add("local-cache", cache.getName());
                            result.add(LocalCacheAdd.createOperation(cacheAddress, cache.getValue()));
                            this.addCacheConfigCommands(cache, cacheAddress, result);
                        }
                        continue;
                    }
                    if (cacheTypeList.getName().equals("invalidation-cache")) {
                        for (Property cache : cacheTypeList.getValue().asPropertyList()) {
                            cacheAddress = containerAddress.clone();
                            cacheAddress.add("invalidation-cache", cache.getName());
                            result.add(InvalidationCacheAdd.createOperation(cacheAddress, cache.getValue()));
                            this.addCacheConfigCommands(cache, cacheAddress, result);
                        }
                        continue;
                    }
                    if (cacheTypeList.getName().equals("replicated-cache")) {
                        for (Property cache : cacheTypeList.getValue().asPropertyList()) {
                            cacheAddress = containerAddress.clone();
                            cacheAddress.add("replicated-cache", cache.getName());
                            result.add(ReplicatedCacheAdd.createOperation(cacheAddress, cache.getValue()));
                            this.addCacheConfigCommands(cache, cacheAddress, result);
                        }
                        continue;
                    }
                    if (!cacheTypeList.getName().equals("distributed-cache")) continue;
                    for (Property cache : cacheTypeList.getValue().asPropertyList()) {
                        cacheAddress = containerAddress.clone();
                        cacheAddress.add("distributed-cache", cache.getName());
                        result.add(DistributedCacheAdd.createOperation(cacheAddress, cache.getValue()));
                        this.addCacheConfigCommands(cache, cacheAddress, result);
                    }
                }
            }
        }
        context.completeStep();
    }

    private void addCacheContainerConfigCommands(Property container, ModelNode address, ModelNode result) throws OperationFailedException {
        if (container.getValue().hasDefined("singleton") && container.getValue().get(new String[]{"singleton", "transport"}).isDefined()) {
            ModelNode transport = container.getValue().get(new String[]{"singleton", "transport"});
            ModelNode transportAddress = address.clone();
            transportAddress.add("singleton", "transport");
            result.add(TransportAdd.createOperation(transportAddress, transport));
        }
    }

    private void addCacheConfigCommands(Property cache, ModelNode address, ModelNode result) throws OperationFailedException {
        if (cache.getValue().hasDefined("singleton")) {
            if (cache.getValue().get(new String[]{"singleton", "locking"}).isDefined()) {
                ModelNode locking = cache.getValue().get(new String[]{"singleton", "locking"});
                ModelNode lockingAddress = address.clone();
                lockingAddress.add("singleton", "locking");
                result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.LOCKING_ATTRIBUTES, lockingAddress, locking));
            }
            if (cache.getValue().get(new String[]{"singleton", "transaction"}).isDefined()) {
                ModelNode transaction = cache.getValue().get(new String[]{"singleton", "transaction"});
                ModelNode transactionAddress = address.clone();
                transactionAddress.add("singleton", "transaction");
                result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.TRANSACTION_ATTRIBUTES, transactionAddress, transaction));
            }
            if (cache.getValue().get(new String[]{"singleton", "eviction"}).isDefined()) {
                ModelNode eviction = cache.getValue().get(new String[]{"singleton", "eviction"});
                ModelNode evictionAddress = address.clone();
                evictionAddress.add("singleton", "eviction");
                result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.EVICTION_ATTRIBUTES, evictionAddress, eviction));
            }
            if (cache.getValue().get(new String[]{"singleton", "expiration"}).isDefined()) {
                ModelNode expiration = cache.getValue().get(new String[]{"singleton", "expiration"});
                ModelNode expirationAddress = address.clone();
                expirationAddress.add("singleton", "expiration");
                result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.EXPIRATION_ATTRIBUTES, expirationAddress, expiration));
            }
            if (cache.getValue().get(new String[]{"singleton", "state-transfer"}).isDefined()) {
                ModelNode stateTransfer = cache.getValue().get(new String[]{"singleton", "state-transfer"});
                ModelNode stateTransferAddress = address.clone();
                stateTransferAddress.add("singleton", "state-transfer");
                result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.STATE_TRANSFER_ATTRIBUTES, stateTransferAddress, stateTransfer));
            }
            if (cache.getValue().get(new String[]{"singleton", "rehashing"}).isDefined()) {
                ModelNode rehashing = cache.getValue().get(new String[]{"singleton", "rehashing"});
                ModelNode rehashingAddress = address.clone();
                rehashingAddress.add("singleton", "rehashing");
                result.add(CacheConfigOperationHandlers.createOperation(CommonAttributes.REHASHING_ATTRIBUTES, rehashingAddress, rehashing));
            }
        }
    }
}

