/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.ejb3.cache.backing.infinispan;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractMap;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.CoreGroupCommunicationServiceService;
import org.jboss.as.clustering.HashableMarshalledValueFactory;
import org.jboss.as.clustering.MarshalledValue;
import org.jboss.as.clustering.MarshalledValueFactory;
import org.jboss.as.clustering.MarshallingContext;
import org.jboss.as.clustering.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.ejb3.cache.backing.infinispan.InfinispanBackingCacheEntryStore;
import org.jboss.as.clustering.ejb3.cache.backing.infinispan.LockKeyFactory;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.FileCacheStoreConfig;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManagerService;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSource;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.as.ejb3.cache.spi.SerializationGroupMember;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntryStoreSource;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class InfinispanBackingCacheEntryStoreSource<K extends Serializable, V extends Cacheable<K>, G extends Serializable>
extends AbstractBackingCacheEntryStoreSource<K, V, G>
implements ClusteredBackingCacheEntryStoreSource<K, V, G> {
    public static final short SCOPE_ID = 223;
    private String cacheName = "sfsb";
    private int maxSize = 10000;
    private boolean passivateEventsOnReplicate = true;
    private final MarshallerFactory factory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)MarshallerFactory.class.getClassLoader());
    private CacheInvoker invoker = new RetryingCacheInvoker(new int[]{0, 0});
    private final InjectedValue<Cache> groupCache = new InjectedValue();
    private final InjectedValue<SharedLocalYieldingClusterLockManager> lockManager = new InjectedValue();

    public void addDependencies(ServiceTarget target, ServiceBuilder<?> builder) {
        ServiceName serviceName;
        ServiceName baseServiceName = EmbeddedCacheManagerService.getServiceName(null);
        if (!baseServiceName.isParentOf(serviceName = ServiceName.parse((String)(this.cacheName != null ? this.cacheName : "sfsb")))) {
            serviceName = baseServiceName.append(serviceName);
        }
        if (serviceName.length() < 4) {
            serviceName = serviceName.append(new String[]{"___defaultcache"});
        }
        String container = serviceName.getParent().getSimpleName();
        new CoreGroupCommunicationServiceService(223).build(target, container).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        new SharedLocalYieldingClusterLockManagerService(container).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        builder.addDependency(serviceName, Cache.class, this.groupCache);
        builder.addDependency(SharedLocalYieldingClusterLockManagerService.getServiceName((String)container), SharedLocalYieldingClusterLockManager.class, this.lockManager);
    }

    public <E extends SerializationGroup<K, V, G>> BackingCacheEntryStore<G, Cacheable<G>, E> createGroupIntegratedObjectStore(PassivationManager<G, E> passivationManager, StatefulTimeoutInfo timeout) {
        AdvancedCache cache = ((Cache)this.groupCache.getValue()).getAdvancedCache().with(((Object)((Object)this)).getClass().getClassLoader());
        MarshallingContext context = new MarshallingContext(this.factory, passivationManager.getMarshallingConfiguration());
        HashableMarshalledValueFactory keyFactory = new HashableMarshalledValueFactory(context);
        SimpleMarshalledValueFactory valueFactory = new SimpleMarshalledValueFactory(context);
        LockKeyFactory lockKeyFactory = new LockKeyFactory<G, MarshallingContext>(){

            @Override
            public Serializable createLockKey(MarshalledValue<G, MarshallingContext> key) {
                return key;
            }
        };
        return new InfinispanBackingCacheEntryStore(cache, this.invoker, null, timeout, (ClusteredBackingCacheEntryStoreConfig)this, false, (MarshalledValueFactory<MarshallingContext>)keyFactory, (MarshalledValueFactory<MarshallingContext>)valueFactory, context, (SharedLocalYieldingClusterLockManager)this.lockManager.getValue(), lockKeyFactory);
    }

    public <E extends SerializationGroupMember<K, V, G>> BackingCacheEntryStore<K, V, E> createIntegratedObjectStore(final String beanName, PassivationManager<K, E> passivationManager, StatefulTimeoutInfo timeout) {
        Cache groupCache = (Cache)this.groupCache.getValue();
        EmbeddedCacheManager container = groupCache.getCacheManager();
        Configuration configuration = new Configuration();
        if (this.maxSize > 0) {
            configuration.fluent().eviction().strategy(EvictionStrategy.LRU).maxEntries(Integer.valueOf(this.maxSize));
        }
        for (CacheLoaderConfig loader : groupCache.getConfiguration().getCacheLoaders()) {
            CacheLoaderConfig config = loader.clone();
            if (config instanceof FileCacheStoreConfig) {
                FileCacheStoreConfig fileConfig = (FileCacheStoreConfig)config;
                fileConfig.path(fileConfig.getPath() + File.separatorChar + beanName);
            }
            configuration.fluent().loaders().addCacheLoader(new CacheLoaderConfig[]{config});
        }
        groupCache.getCacheManager().defineConfiguration(beanName, groupCache.getName(), configuration);
        AdvancedCache cache = container.getCache(beanName).getAdvancedCache().with(((Object)((Object)this)).getClass().getClassLoader());
        MarshallingContext context = new MarshallingContext(this.factory, passivationManager.getMarshallingConfiguration());
        HashableMarshalledValueFactory keyFactory = new HashableMarshalledValueFactory(context);
        SimpleMarshalledValueFactory valueFactory = new SimpleMarshalledValueFactory(context);
        LockKeyFactory lockKeyFactory = new LockKeyFactory<K, MarshallingContext>(){

            @Override
            public Serializable createLockKey(MarshalledValue<K, MarshallingContext> key) {
                return new AbstractMap.SimpleImmutableEntry(key, beanName);
            }
        };
        return new InfinispanBackingCacheEntryStore(cache, this.invoker, this.passivateEventsOnReplicate ? passivationManager : null, timeout, (ClusteredBackingCacheEntryStoreConfig)this, true, (MarshalledValueFactory<MarshallingContext>)keyFactory, (MarshalledValueFactory<MarshallingContext>)valueFactory, context, (SharedLocalYieldingClusterLockManager)this.lockManager.getValue(), lockKeyFactory);
    }

    public String getBackingCache() {
        return this.cacheName;
    }

    public void setBackingCache(String cacheName) {
        this.cacheName = cacheName;
    }

    public boolean isPassivateEventsOnReplicate() {
        return this.passivateEventsOnReplicate;
    }

    public void setPassivateEventsOnReplicate(boolean passivateEventsOnReplicate) {
        this.passivateEventsOnReplicate = passivateEventsOnReplicate;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

