/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import org.jboss.as.mail.extension.Credentials;
import org.jboss.as.mail.extension.MailMessages;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.MailSessionServer;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class MailSessionService
implements Service<Session> {
    private static final Logger log = Logger.getLogger(MailSessionService.class);
    private volatile Properties props;
    private final MailSessionConfig config;
    private Map<String, OutboundSocketBinding> socketBindings = new HashMap<String, OutboundSocketBinding>();

    public MailSessionService(MailSessionConfig config) {
        log.tracef("service constructed with config: %s", (Object)config);
        this.config = config;
    }

    public void start(StartContext startContext) throws StartException {
        log.trace((Object)"start...");
        this.props = this.getProperties();
    }

    public void stop(StopContext stopContext) {
        log.trace((Object)"stop...");
    }

    Injector<OutboundSocketBinding> getSocketBindingInjector(String name) {
        return new MapInjector(this.socketBindings, (Object)name);
    }

    private Properties getProperties() throws StartException {
        InetSocketAddress socketAddress;
        Properties props = new Properties();
        if (this.config.getSmtpServer() != null) {
            props.put("mail.transport.protocol", "smtp");
            socketAddress = this.getServerSocketAddress(this.config.getSmtpServer());
            props.put(MailSessionService.getHostKey("smtp"), socketAddress.getAddress().getHostName());
            props.put(MailSessionService.getPortKey("smtp"), (Object)socketAddress.getPort());
        }
        if (this.config.getImapServer() != null) {
            socketAddress = this.getServerSocketAddress(this.config.getImapServer());
            props.put(MailSessionService.getHostKey("imap"), socketAddress.getAddress().getHostName());
            props.put(MailSessionService.getPortKey("imap"), (Object)socketAddress.getPort());
        }
        if (this.config.getPop3Server() != null) {
            socketAddress = this.getServerSocketAddress(this.config.getPop3Server());
            props.put(MailSessionService.getHostKey("pop3"), socketAddress.getAddress().getHostName());
            props.put(MailSessionService.getPortKey("pop3"), (Object)socketAddress.getPort());
        }
        props.put("mail.debug", (Object)this.config.isDebug());
        log.tracef("props: %s", (Object)props);
        return props;
    }

    private void setAuthentication(Session session) {
        this.setAuthForServer(session, this.config.getSmtpServer(), "smtp");
        this.setAuthForServer(session, this.config.getPop3Server(), "pop3");
        this.setAuthForServer(session, this.config.getImapServer(), "imap");
    }

    private void setAuthForServer(Session session, MailSessionServer server, String protocol) {
        if (server != null) {
            String host = (String)String.class.cast(this.props.get(MailSessionService.getHostKey(protocol)));
            int port = (Integer)Integer.class.cast(this.props.get(MailSessionService.getPortKey(protocol)));
            Credentials c = server.getCredentials();
            URLName urlName = new URLName(protocol, host, port, "", c != null ? c.getUsername() : null, c != null ? c.getPassword() : null);
            if (c != null) {
                session.setPasswordAuthentication(urlName, new PasswordAuthentication(c.getUsername(), c.getPassword()));
            }
        }
    }

    private InetSocketAddress getServerSocketAddress(MailSessionServer server) throws StartException {
        InetAddress destinationAddress;
        String ref = server.getOutgoingSocketBinding();
        OutboundSocketBinding binding = this.socketBindings.get(ref);
        if (ref == null) {
            throw MailMessages.MESSAGES.outboundSocketBindingNotAvailable(ref);
        }
        try {
            destinationAddress = binding.getDestinationAddress();
        }
        catch (UnknownHostException uhe) {
            throw MailMessages.MESSAGES.unknownOutboundSocketBindingDesintation(uhe, ref);
        }
        return new InetSocketAddress(destinationAddress, binding.getDestinationPort());
    }

    public Session getValue() throws IllegalStateException, IllegalArgumentException {
        Session session = Session.getInstance((Properties)this.props);
        this.setAuthentication(session);
        return session;
    }

    private static String getHostKey(String protocol) {
        return "mail." + protocol + ".host";
    }

    private static String getPortKey(String protocol) {
        return "mail." + protocol + ".port";
    }
}

