/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.injection.InjectionHelper;
import org.jboss.ws.common.injection.PreDestroyHolder;
import org.jboss.ws.core.server.netty.NettyCallbackHandler;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.EndpointResolver;
import org.jboss.wsf.stack.jbws.WebAppResolver;

final class NettyCallbackHandlerImpl
implements NettyCallbackHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NettyCallbackHandlerImpl.class);
    private static final Logger LOGGER = Logger.getLogger(NettyCallbackHandlerImpl.class);
    private static final SPIProvider SPI_PROVIDER = SPIProviderResolver.getInstance().getProvider();
    private static final EndpointRegistry ENDPOINTS_REGISTRY = ((EndpointRegistryFactory)SPI_PROVIDER.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
    private final List<PreDestroyHolder> preDestroyRegistry = new LinkedList<PreDestroyHolder>();
    private final String handledPath;
    private Endpoint endpoint;

    public NettyCallbackHandlerImpl(String path, String context, String endpointRegistryPath) {
        this.initEndpoint(context, endpointRegistryPath);
        this.handledPath = path;
    }

    private void initEndpoint(String context, String endpointRegistryPath) {
        WebAppResolver resolver = new WebAppResolver(context, endpointRegistryPath);
        this.endpoint = ENDPOINTS_REGISTRY.resolve((EndpointResolver)resolver);
        if (this.endpoint == null) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_ENDPOINT", (Object[])new Object[]{endpointRegistryPath}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String method, InputStream is, OutputStream os, InvocationContext invCtx) throws IOException {
        block19: {
            try {
                EndpointAssociation.setEndpoint((Endpoint)this.endpoint);
                RequestHandler requestHandler = this.endpoint.getRequestHandler();
                if (method.equals("POST")) {
                    requestHandler.handleRequest(this.endpoint, is, os, invCtx);
                    break block19;
                }
                if (method.equals("GET")) {
                    requestHandler.handleWSDLRequest(this.endpoint, os, invCtx);
                    break block19;
                }
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_HTTP_METHOD", (Object[])new Object[]{method}));
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                this.registerForPreDestroy(this.endpoint);
                EndpointAssociation.removeEndpoint();
            }
        }
    }

    @Override
    public String getPath() {
        return this.handledPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForPreDestroy(Endpoint endpoint) {
        PreDestroyHolder holder = (PreDestroyHolder)endpoint.getAttachment(PreDestroyHolder.class);
        if (holder != null) {
            List<PreDestroyHolder> list = this.preDestroyRegistry;
            synchronized (list) {
                if (!this.preDestroyRegistry.contains(holder)) {
                    this.preDestroyRegistry.add(holder);
                }
            }
            endpoint.removeAttachment(PreDestroyHolder.class);
        }
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        List<PreDestroyHolder> list = this.preDestroyRegistry;
        synchronized (list) {
            for (PreDestroyHolder holder : this.preDestroyRegistry) {
                try {
                    Object targetBean = holder.getObject();
                    InjectionHelper.callPreDestroyMethod((Object)targetBean);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            this.preDestroyRegistry.clear();
        }
    }
}

