/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.util.ResourceBundle;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.api.annotation.WebContext;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSProviderMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSWebServiceMetaDataBuilder;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;

public abstract class JAXWSServerMetaDataBuilder
extends JAXWSMetaDataBuilder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JAXWSServerMetaDataBuilder.class);

    static void setupProviderOrWebService(ArchiveDeployment dep, UnifiedMetaData umd, Class<?> beanClass, String beanName) throws Exception {
        if (beanClass.isAnnotationPresent(WebService.class)) {
            JAXWSWebServiceMetaDataBuilder builder = new JAXWSWebServiceMetaDataBuilder();
            builder.buildWebServiceMetaData((Deployment)dep, umd, beanClass, beanName);
        } else if (beanClass.isAnnotationPresent(WebServiceProvider.class)) {
            JAXWSProviderMetaDataBuilder builder = new JAXWSProviderMetaDataBuilder();
            builder.buildProviderMetaData(dep, umd, beanClass, beanName);
        }
    }

    protected void processEndpointConfig(Deployment dep, ServerEndpointMetaData sepMetaData, Class<?> wsClass, String linkName) {
        EJBArchiveMetaData ejbMetaData;
        JSEArchiveMetaData jseMetaData;
        String configName = null;
        String configFile = null;
        EndpointConfig anEndpointConfig = wsClass.getAnnotation(EndpointConfig.class);
        if (anEndpointConfig != null) {
            if (anEndpointConfig.configName().length() > 0) {
                configName = anEndpointConfig.configName();
            }
            if (anEndpointConfig.configFile().length() > 0) {
                configFile = anEndpointConfig.configFile();
            }
        }
        if ((jseMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class)) != null) {
            if (jseMetaData.getConfigName() != null) {
                configName = jseMetaData.getConfigName();
            }
            if (jseMetaData.getConfigFile() != null) {
                configFile = jseMetaData.getConfigFile();
            }
        }
        if ((ejbMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class)) != null) {
            if (ejbMetaData.getConfigName() != null) {
                configName = ejbMetaData.getConfigName();
            }
            if (ejbMetaData.getConfigFile() != null) {
                configFile = ejbMetaData.getConfigFile();
            }
        }
        if (configName != null || configFile != null) {
            sepMetaData.setConfigName(configName, configFile);
        }
    }

    protected void processWebContext(Deployment dep, Class<?> wsClass, String linkName, ServerEndpointMetaData sepMetaData) {
        WebContext anWebContext = wsClass.getAnnotation(WebContext.class);
        if (anWebContext == null) {
            return;
        }
        boolean isJSEEndpoint = WSHelper.isJaxwsJseDeployment((Deployment)dep);
        if (anWebContext.contextRoot().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONTEXTROOT_IS_ONLY_VALID_ON_EJB_ENDPOINTS", (Object[])new Object[0]));
            } else {
                String contextRoot = anWebContext.contextRoot();
                if (!contextRoot.startsWith("/")) {
                    contextRoot = "/" + contextRoot;
                }
                sepMetaData.setContextRoot(contextRoot);
            }
        }
        if (anWebContext.urlPattern().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"URLPATTERN_IS_ONLY_VALID_ON_EJB_ENDPOINTS", (Object[])new Object[0]));
            } else {
                String urlPattern = anWebContext.urlPattern();
                sepMetaData.setURLPattern(urlPattern);
            }
        }
        if (anWebContext.authMethod().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"AUTHMETHOD_IS_ONLY_VALID_ON_EJB_ENDPOINTS", (Object[])new Object[0]));
            } else {
                String authMethod = anWebContext.authMethod();
                sepMetaData.setAuthMethod(authMethod);
            }
        }
        if (anWebContext.transportGuarantee().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"TRANSPORTGUARANTEE_IS_ONLY_VALID_ON_EJB_ENDPOINTS", (Object[])new Object[0]));
            } else {
                String transportGuarantee = anWebContext.transportGuarantee();
                sepMetaData.setTransportGuarantee(transportGuarantee);
            }
        }
        sepMetaData.setSecureWSDLAccess(anWebContext.secureWSDLAccess());
    }
}

