/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.noopts;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.InitialContext;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.jca.core.tx.noopts.TransactionImpl;
import org.jboss.jca.core.tx.noopts.TxRegistry;

public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JNDI_NAME = "java:/TransactionSynchronizationRegistry";
    private TxRegistry registry = null;
    private ConcurrentMap<Long, TxEnv> txe = new ConcurrentHashMap<Long, TxEnv>();

    public void setRegistry(TxRegistry v) {
        this.registry = v;
    }

    public Object getTransactionKey() {
        return this.getKey();
    }

    public void putResource(Object key, Object value) {
        TxEnv env = this.getTxEnv();
        env.getEnvironment().put(key, value);
    }

    public Object getResource(Object key) {
        TxEnv env = this.getTxEnv();
        return env.getEnvironment().get(key);
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        try {
            tx.registerSynchronization(sync);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getTransactionStatus() {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            return 6;
        }
        try {
            return tx.getStatus();
        }
        catch (Throwable t) {
            return 5;
        }
    }

    public void setRollbackOnly() {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        try {
            tx.setRollbackOnly();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean getRollbackOnly() {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        return tx.getRollbackOnly();
    }

    public void start() throws Throwable {
        InitialContext context = new InitialContext();
        context.bind(JNDI_NAME, (Object)this);
        context.close();
    }

    public void stop() throws Throwable {
        InitialContext context = new InitialContext();
        context.unbind(JNDI_NAME);
        context.close();
    }

    private Long getKey() {
        return Thread.currentThread().getId();
    }

    private TxEnv getTxEnv() {
        TxEnv newTxEnv;
        Long key = this.getKey();
        TxEnv env = (TxEnv)this.txe.get(key);
        if (env == null && (env = this.txe.putIfAbsent(key, newTxEnv = new TxEnv())) == null) {
            env = newTxEnv;
        }
        return env;
    }

    static class TxEnv
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<Object, Object> envs = new HashMap<Object, Object>(1);

        TxEnv() {
        }

        Map<Object, Object> getEnvironment() {
            return this.envs;
        }
    }
}

