/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.locking.AwaitInfo;
import org.jgroups.blocks.locking.LockInfo;
import org.jgroups.blocks.locking.LockNotification;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Owner;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

@MBean(description="Based class for locking functionality")
public abstract class Locking
extends Protocol {
    @Property(description="bypasses message bundling if set")
    protected boolean bypass_bundling = true;
    protected Address local_addr;
    protected View view;
    protected final ConcurrentMap<String, ServerLock> server_locks = Util.createConcurrentMap(20);
    protected final Map<String, Map<Owner, ClientLock>> client_locks = new HashMap<String, Map<Owner, ClientLock>>();
    protected final Set<LockNotification> lock_listeners = new HashSet<LockNotification>();

    public boolean getBypassBundling() {
        return this.bypass_bundling;
    }

    public void setBypassBundling(boolean bypass_bundling) {
        this.bypass_bundling = bypass_bundling;
    }

    public void addLockListener(LockNotification listener) {
        if (listener != null) {
            this.lock_listeners.add(listener);
        }
    }

    public void removeLockListener(LockNotification listener) {
        if (listener != null) {
            this.lock_listeners.remove(listener);
        }
    }

    @ManagedAttribute
    public String getAddress() {
        return this.local_addr != null ? this.local_addr.toString() : null;
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.toString() : null;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 95: {
                LockInfo info = (LockInfo)evt.getArg();
                ClientLock lock = this.getLock(info.getName());
                if (!info.isTrylock()) {
                    if (info.isLockInterruptibly()) {
                        try {
                            lock.lockInterruptibly();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    } else {
                        lock.lock();
                    }
                } else if (info.isUseTimeout()) {
                    try {
                        return lock.tryLock(info.getTimeout(), info.getTimeUnit());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    return lock.tryLock();
                }
                return null;
            }
            case 96: {
                LockInfo info = (LockInfo)evt.getArg();
                ClientLock lock = this.getLock(info.getName(), false);
                if (lock != null) {
                    lock.unlock();
                }
                return null;
            }
            case 97: {
                this.unlockAll();
                return null;
            }
            case 98: {
                LockInfo info = (LockInfo)evt.getArg();
                ClientLock lock = this.getLock(info.getName(), false);
                if (lock == null || !lock.acquired) {
                    throw new IllegalMonitorStateException();
                }
                Condition condition = lock.newCondition();
                if (info.isUseTimeout()) {
                    try {
                        return condition.awaitNanos(info.getTimeUnit().toNanos(info.getTimeout()));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (info.isLockInterruptibly()) {
                    try {
                        condition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    break;
                }
                condition.awaitUninterruptibly();
                break;
            }
            case 99: {
                AwaitInfo awaitInfo = (AwaitInfo)evt.getArg();
                ClientLock lock = this.getLock(awaitInfo.getName(), false);
                if (lock == null || !lock.acquired) {
                    throw new IllegalMonitorStateException();
                }
                this.sendSignalConditionRequest(awaitInfo.getName(), awaitInfo.isAll());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                LockingHeader hdr = (LockingHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                Request req = (Request)msg.getObject();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[" + this.local_addr + "] <-- [" + msg.getSrc() + "] " + req);
                }
                switch (req.type) {
                    case GRANT_LOCK: 
                    case RELEASE_LOCK: {
                        this.handleLockRequest(req);
                        break;
                    }
                    case LOCK_GRANTED: {
                        this.handleLockGrantedResponse(req.lock_name, req.owner, msg.getSrc());
                        break;
                    }
                    case LOCK_DENIED: {
                        this.handleLockDeniedResponse(req.lock_name, req.owner);
                        break;
                    }
                    case CREATE_LOCK: {
                        this.handleCreateLockRequest(req.lock_name, req.owner);
                        break;
                    }
                    case DELETE_LOCK: {
                        this.handleDeleteLockRequest(req.lock_name);
                        break;
                    }
                    case COND_SIG: 
                    case COND_SIG_ALL: {
                        this.handleSignalRequest(req);
                        break;
                    }
                    case LOCK_AWAIT: {
                        this.handleAwaitRequest(req.lock_name, req.owner);
                        this.handleLockRequest(req);
                        break;
                    }
                    case DELETE_LOCK_AWAIT: {
                        this.handleDeleteAwaitRequest(req.lock_name, req.owner);
                        break;
                    }
                    case SIG_RET: {
                        this.handleSignalResponse(req.lock_name, req.owner);
                        break;
                    }
                    case CREATE_AWAITER: {
                        this.handleCreateAwaitingRequest(req.lock_name, req.owner);
                        break;
                    }
                    case DELETE_AWAITER: {
                        this.handleDeleteAwaitingRequest(req.lock_name, req.owner);
                        break;
                    }
                    default: {
                        this.log.error("Request of type " + (Object)((Object)req.type) + " not known");
                    }
                }
                return null;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    protected ClientLock getLock(String name) {
        return this.getLock(name, this.getOwner(), true);
    }

    protected ClientLock getLock(String name, boolean create_if_absent) {
        return this.getLock(name, this.getOwner(), create_if_absent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Unlocks all currently held locks")
    public void unlockAll() {
        ArrayList<ClientLock> locks = new ArrayList<ClientLock>();
        Map<String, Map<Owner, ClientLock>> map = this.client_locks;
        synchronized (map) {
            Collection<Map<Owner, ClientLock>> maps = this.client_locks.values();
            for (Map<Owner, ClientLock> map2 : maps) {
                locks.addAll(map2.values());
            }
        }
        for (ClientLock lock : locks) {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Dumps all locks")
    public String printLocks() {
        StringBuilder sb = new StringBuilder();
        sb.append("server locks:\n");
        for (Map.Entry entry : this.server_locks.entrySet()) {
            sb.append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        sb.append("\nmy locks: ");
        Map<String, Map<Owner, ClientLock>> map = this.client_locks;
        synchronized (map) {
            boolean first_element = true;
            for (Map.Entry<String, Map<Owner, ClientLock>> entry : this.client_locks.entrySet()) {
                if (first_element) {
                    first_element = false;
                } else {
                    sb.append(", ");
                }
                sb.append(entry.getKey()).append(" (");
                Map<Owner, ClientLock> owners = entry.getValue();
                boolean first = true;
                for (Map.Entry<Owner, ClientLock> entry2 : owners.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(entry2.getKey());
                    ClientLock cl = entry2.getValue();
                    if (cl.acquired && !cl.denied) continue;
                    sb.append(", unlocked");
                }
                sb.append(")");
            }
        }
        return sb.toString();
    }

    protected void handleView(View view) {
        this.view = view;
        if (this.log.isDebugEnabled()) {
            this.log.debug("view=" + view);
        }
        List<Address> members = view.getMembers();
        for (Map.Entry entry : this.server_locks.entrySet()) {
            ((ServerLock)entry.getValue()).handleView(members);
        }
        for (Map.Entry entry : this.server_locks.entrySet()) {
            ServerLock lock = (ServerLock)entry.getValue();
            if (!lock.isEmpty() || lock.current_owner != null) continue;
            this.server_locks.remove(entry.getKey());
        }
    }

    protected ClientLock createLock(String lock_name) {
        return new ClientLock(lock_name);
    }

    protected Owner getOwner() {
        return new Owner(this.local_addr, Thread.currentThread().getId());
    }

    protected abstract void sendGrantLockRequest(String var1, Owner var2, long var3, boolean var5);

    protected abstract void sendReleaseLockRequest(String var1, Owner var2);

    protected abstract void sendAwaitConditionRequest(String var1, Owner var2);

    protected abstract void sendSignalConditionRequest(String var1, boolean var2);

    protected abstract void sendDeleteAwaitConditionRequest(String var1, Owner var2);

    protected void sendRequest(Address dest, Type type, String lock_name, Owner owner, long timeout, boolean is_trylock) {
        Request req = new Request(type, lock_name, owner, timeout, is_trylock);
        Message msg = new Message(dest, null, req);
        msg.putHeader(this.id, new LockingHeader());
        if (this.bypass_bundling) {
            msg.setFlag((byte)2);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("[" + this.local_addr + "] --> [" + (dest == null ? "ALL" : dest) + "] " + req);
        }
        try {
            this.down_prot.down(new Event(1, msg));
        }
        catch (Exception ex) {
            this.log.error("failed sending " + (Object)((Object)type) + " request: " + ex);
        }
    }

    protected void sendLockResponse(Type type, Owner dest, String lock_name) {
        Request rsp = new Request(type, lock_name, dest, 0L);
        Message lock_granted_rsp = new Message(dest.getAddress(), null, rsp);
        lock_granted_rsp.putHeader(this.id, new LockingHeader());
        if (this.bypass_bundling) {
            lock_granted_rsp.setFlag((byte)2);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("[" + this.local_addr + "] --> [" + dest.getAddress() + "] " + rsp);
        }
        try {
            this.down_prot.down(new Event(1, lock_granted_rsp));
        }
        catch (Exception ex) {
            this.log.error("failed sending " + (Object)((Object)type) + " message to " + dest + ": " + ex);
        }
    }

    protected void sendSignalResponse(Owner dest, String lock_name) {
        Request rsp = new Request(Type.SIG_RET, lock_name, dest, 0L);
        Message lock_granted_rsp = new Message(dest.getAddress(), null, rsp);
        lock_granted_rsp.putHeader(this.id, new LockingHeader());
        if (this.bypass_bundling) {
            lock_granted_rsp.setFlag((byte)2);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("[" + this.local_addr + "] --> [" + dest.getAddress() + "] " + rsp);
        }
        try {
            this.down_prot.down(new Event(1, lock_granted_rsp));
        }
        catch (Exception ex) {
            this.log.error("failed sending " + (Object)((Object)Type.SIG_RET) + " message to " + dest + ": " + ex);
        }
    }

    protected void handleLockRequest(Request req) {
        ServerLock lock = (ServerLock)this.server_locks.get(req.lock_name);
        if (lock == null) {
            lock = new ServerLock(req.lock_name);
            ServerLock tmp = this.server_locks.putIfAbsent(req.lock_name, lock);
            if (tmp != null) {
                lock = tmp;
            } else {
                this.notifyLockCreated(req.lock_name);
            }
        }
        lock.handleRequest(req);
        if (lock.isEmpty() && lock.current_owner == null && lock.condition.queue.isEmpty()) {
            this.server_locks.remove(req.lock_name);
        }
    }

    protected void handleLockGrantedResponse(String lock_name, Owner owner, Address sender) {
        ClientLock lock = this.getLock(lock_name, owner, false);
        if (lock != null) {
            lock.handleLockGrantedResponse(owner, sender);
        }
    }

    protected void handleLockDeniedResponse(String lock_name, Owner owner) {
        ClientLock lock = this.getLock(lock_name, owner, false);
        if (lock != null) {
            lock.lockDenied();
        }
    }

    protected void handleAwaitRequest(String lock_name, Owner owner) {
        ServerLock lock = (ServerLock)this.server_locks.get(lock_name);
        if (lock != null) {
            lock.condition.addWaiter(owner);
        } else {
            this.log.error("Condition await was received but lock was not created.  Waiter may block forever");
        }
    }

    protected void handleDeleteAwaitRequest(String lock_name, Owner owner) {
        ServerLock lock = (ServerLock)this.server_locks.get(lock_name);
        if (lock != null) {
            lock.condition.removeWaiter(owner);
        } else {
            this.log.error("Condition await delete was received, but lock was gone");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSignalResponse(String lock_name, Owner owner) {
        ClientLock lock = this.getLock(lock_name, owner, false);
        if (lock != null) {
            ClientCondition clientCondition = lock.condition;
            synchronized (clientCondition) {
                lock.condition.signaled();
            }
        } else {
            this.log.error("Condition response was client lock was not present.  Ignored signal.");
        }
    }

    protected void handleSignalRequest(Request req) {
        ServerLock lock = (ServerLock)this.server_locks.get(req.lock_name);
        if (lock != null) {
            lock.handleRequest(req);
        } else {
            this.log.error("Condition signal was received but lock was not created.  Couldn't notify anyone.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateLockRequest(String lock_name, Owner owner) {
        ConcurrentMap<String, ServerLock> concurrentMap = this.server_locks;
        synchronized (concurrentMap) {
            this.server_locks.put(lock_name, new ServerLock(lock_name, owner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeleteLockRequest(String lock_name) {
        ConcurrentMap<String, ServerLock> concurrentMap = this.server_locks;
        synchronized (concurrentMap) {
            ServerLock lock = (ServerLock)this.server_locks.get(lock_name);
            if (lock == null) {
                return;
            }
            ServerCondition serverCondition = lock.condition;
            synchronized (serverCondition) {
                if (lock.condition.queue.isEmpty()) {
                    this.server_locks.remove(lock_name);
                } else {
                    lock.current_owner = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateAwaitingRequest(String lock_name, Owner owner) {
        ConcurrentMap<String, ServerLock> concurrentMap = this.server_locks;
        synchronized (concurrentMap) {
            ServerLock lock = (ServerLock)this.server_locks.get(lock_name);
            if (lock == null) {
                lock = new ServerLock(lock_name);
            }
            lock.condition.queue.add(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeleteAwaitingRequest(String lock_name, Owner owner) {
        ConcurrentMap<String, ServerLock> concurrentMap = this.server_locks;
        synchronized (concurrentMap) {
            ServerLock lock = (ServerLock)this.server_locks.get(lock_name);
            if (lock != null) {
                ServerCondition serverCondition = lock.condition;
                synchronized (serverCondition) {
                    lock.condition.queue.remove(owner);
                    if (lock.condition.queue.isEmpty() && lock.current_owner == null) {
                        this.server_locks.remove(lock_name);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientLock getLock(String name, Owner owner, boolean create_if_absent) {
        Map<String, Map<Owner, ClientLock>> map = this.client_locks;
        synchronized (map) {
            ClientLock lock;
            Map<Owner, ClientLock> owners = this.client_locks.get(name);
            if (owners == null) {
                if (!create_if_absent) {
                    return null;
                }
                owners = new HashMap<Owner, ClientLock>();
                this.client_locks.put(name, owners);
            }
            if ((lock = owners.get(owner)) == null) {
                if (!create_if_absent) {
                    return null;
                }
                lock = this.createLock(name);
                owners.put(owner, lock);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClientLock(String lock_name, Owner owner) {
        Map<String, Map<Owner, ClientLock>> map = this.client_locks;
        synchronized (map) {
            ClientLock lock;
            Map<Owner, ClientLock> owners = this.client_locks.get(lock_name);
            if (owners != null && (lock = owners.remove(owner)) != null && owners.isEmpty()) {
                this.client_locks.remove(lock_name);
            }
        }
    }

    protected void notifyLockCreated(String lock_name) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.lockCreated(lock_name);
            }
            catch (Throwable t) {
                this.log.error("failed notifying " + listener, t);
            }
        }
    }

    protected void notifyLockDeleted(String lock_name) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.lockDeleted(lock_name);
            }
            catch (Throwable t) {
                this.log.error("failed notifying " + listener, t);
            }
        }
    }

    protected void notifyLocked(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.locked(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("failed notifying " + listener, t);
            }
        }
    }

    protected void notifyUnlocked(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.unlocked(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("failed notifying " + listener, t);
            }
        }
    }

    protected void notifyAwaiting(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.awaiting(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("failed notifying " + listener, t);
            }
        }
    }

    protected void notifyAwaited(String lock_name, Owner owner) {
        for (LockNotification listener : this.lock_listeners) {
            try {
                listener.awaited(lock_name, owner);
            }
            catch (Throwable t) {
                this.log.error("failed notifying " + listener, t);
            }
        }
    }

    public static class LockingHeader
    extends Header {
        @Override
        public int size() {
            return 0;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
        }
    }

    protected static class Request
    implements Streamable {
        protected Type type;
        protected String lock_name;
        protected Owner owner;
        protected long timeout = 0L;
        protected boolean is_trylock;

        public Request() {
        }

        public Request(Type type, String lock_name, Owner owner, long timeout) {
            this.type = type;
            this.lock_name = lock_name;
            this.owner = owner;
            this.timeout = timeout;
        }

        public Request(Type type, String lock_name, Owner owner, long timeout, boolean is_trylock) {
            this(type, lock_name, owner, timeout);
            this.is_trylock = is_trylock;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type.ordinal());
            Util.writeString(this.lock_name, out);
            Util.writeStreamable(this.owner, out);
            out.writeLong(this.timeout);
            out.writeBoolean(this.is_trylock);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = Type.values()[in.readByte()];
            this.lock_name = Util.readString(in);
            this.owner = (Owner)Util.readStreamable(Owner.class, in);
            this.timeout = in.readLong();
            this.is_trylock = in.readBoolean();
        }

        public String toString() {
            return this.type.name() + " [" + this.lock_name + ", owner=" + this.owner + (this.is_trylock ? ", trylock " : " ") + (this.timeout > 0L ? "(timeout=" + this.timeout + ")" : "]");
        }

        public String toStringShort() {
            StringBuilder sb = new StringBuilder();
            switch (this.type) {
                case RELEASE_LOCK: {
                    sb.append("U");
                    break;
                }
                case GRANT_LOCK: {
                    sb.append(this.is_trylock ? "TL" : "L");
                    break;
                }
                default: {
                    sb.append("N/A");
                }
            }
            sb.append("(").append(this.lock_name).append(",").append(this.owner);
            if (this.timeout > 0L) {
                sb.append(",").append(this.timeout);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    protected class ClientCondition
    implements Condition {
        protected final ClientLock lock;
        protected final AtomicBoolean signaled = new AtomicBoolean(false);
        protected volatile AtomicReference<Thread> parker = new AtomicReference();

        public ClientCondition(ClientLock lock) {
            this.lock = lock;
        }

        @Override
        public void await() throws InterruptedException {
            InterruptedException ex = null;
            try {
                this.await(true);
            }
            catch (InterruptedException e) {
                ex = e;
                throw ex;
            }
            finally {
                this.lock.lock();
                if (ex != null) {
                    Thread.interrupted();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void awaitUninterruptibly() {
            try {
                this.await(false);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.lock.lock();
            }
        }

        @Override
        public long awaitNanos(long nanosTimeout) throws InterruptedException {
            long beforeLock;
            InterruptedException ex = null;
            try {
                beforeLock = this.await(nanosTimeout) + System.nanoTime();
            }
            catch (InterruptedException e) {
                ex = e;
                throw ex;
            }
            finally {
                this.lock.lock();
                if (ex != null) {
                    Thread.interrupted();
                }
            }
            return beforeLock - System.nanoTime();
        }

        @Override
        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            return this.awaitNanos(unit.toNanos(time)) > 0L;
        }

        @Override
        public boolean awaitUntil(Date deadline) throws InterruptedException {
            long currentTime;
            long waitUntilTime = deadline.getTime();
            long waitTime = waitUntilTime - (currentTime = System.currentTimeMillis());
            if (waitTime > 0L) {
                return this.await(waitTime, TimeUnit.MILLISECONDS);
            }
            return false;
        }

        protected void await(boolean throwInterrupt) throws InterruptedException {
            if (!this.signaled.get()) {
                this.lock.acquired = false;
                Locking.this.sendAwaitConditionRequest(this.lock.name, this.lock.owner);
                boolean interrupted = false;
                while (!this.signaled.get()) {
                    this.parker.set(Thread.currentThread());
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    if (!this.signaled.get()) {
                        Locking.this.sendDeleteAwaitConditionRequest(this.lock.name, this.lock.owner);
                        throw new InterruptedException();
                    }
                    interrupted = true;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            this.signaled.set(false);
        }

        protected long await(long nanoSeconds) throws InterruptedException {
            long target_nano = System.nanoTime() + nanoSeconds;
            if (!this.signaled.get()) {
                long wait_nano;
                this.lock.acquired = false;
                Locking.this.sendAwaitConditionRequest(this.lock.name, this.lock.owner);
                boolean interrupted = false;
                while (!this.signaled.get() && (wait_nano = target_nano - System.nanoTime()) > 0L) {
                    this.parker.set(Thread.currentThread());
                    LockSupport.parkNanos(this, wait_nano);
                    if (!Thread.interrupted()) continue;
                    if (!this.signaled.get()) {
                        Locking.this.sendDeleteAwaitConditionRequest(this.lock.name, this.lock.owner);
                        throw new InterruptedException();
                    }
                    interrupted = true;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.signaled.getAndSet(false)) {
                Locking.this.sendDeleteAwaitConditionRequest(this.lock.name, this.lock.owner);
            }
            return target_nano - System.nanoTime();
        }

        @Override
        public void signal() {
            Locking.this.sendSignalConditionRequest(this.lock.name, false);
        }

        @Override
        public void signalAll() {
            Locking.this.sendSignalConditionRequest(this.lock.name, true);
        }

        protected void signaled() {
            this.signaled.set(true);
            Thread thread = this.parker.getAndSet(null);
            if (thread != null) {
                LockSupport.unpark(thread);
            }
        }
    }

    protected class ClientLock
    implements Lock {
        protected final String name;
        protected Owner owner;
        protected volatile boolean acquired;
        protected volatile boolean denied;
        protected volatile boolean is_trylock;
        protected long timeout;
        protected final ClientCondition condition;

        public ClientLock(String name) {
            this.name = name;
            this.condition = new ClientCondition(this);
        }

        @Override
        public void lock() {
            try {
                this.acquire(false);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.acquire(true);
        }

        @Override
        public boolean tryLock() {
            try {
                return this.acquireTryLock(0L, false);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.acquireTryLock(TimeUnit.MILLISECONDS.convert(time, unit), true);
        }

        @Override
        public synchronized void unlock() {
            this._unlock(false);
        }

        @Override
        public Condition newCondition() {
            return this.condition;
        }

        public String toString() {
            return this.name + " (locked=" + this.acquired + ")";
        }

        protected synchronized void lockGranted() {
            this.acquired = true;
            this.notifyAll();
        }

        protected synchronized void lockDenied() {
            this.denied = true;
            this.notifyAll();
        }

        protected void handleLockGrantedResponse(Owner owner, Address sender) {
            this.lockGranted();
        }

        protected synchronized void acquire(boolean throwInterrupt) throws InterruptedException {
            if (!this.acquired) {
                this.owner = Locking.this.getOwner();
                Locking.this.sendGrantLockRequest(this.name, this.owner, 0L, false);
                boolean interrupted = false;
                while (!this.acquired) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (throwInterrupt && !this.acquired) {
                            this._unlock(true);
                            throw e;
                        }
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        protected synchronized void _unlock(boolean force) {
            if (!(this.acquired || this.denied || force)) {
                return;
            }
            this.timeout = 0L;
            this.is_trylock = false;
            Locking.this.sendReleaseLockRequest(this.name, this.owner);
            this.denied = false;
            this.acquired = false;
            this.notifyAll();
            Locking.this.removeClientLock(this.name, this.owner);
            Locking.this.notifyLockDeleted(this.name);
            this.owner = null;
        }

        protected synchronized boolean acquireTryLock(long timeout, boolean use_timeout) throws InterruptedException {
            if (this.denied) {
                return false;
            }
            if (!this.acquired) {
                this.is_trylock = true;
                this.timeout = timeout;
                this.owner = Locking.this.getOwner();
                Locking.this.sendGrantLockRequest(this.name, this.owner, timeout, true);
                long target_time = use_timeout ? System.currentTimeMillis() + timeout : 0L;
                boolean interrupted = false;
                while (!this.acquired && !this.denied) {
                    if (use_timeout) {
                        long wait_time = target_time - System.currentTimeMillis();
                        if (wait_time <= 0L) break;
                        this.timeout = wait_time;
                        try {
                            this.wait(wait_time);
                        }
                        catch (InterruptedException e) {
                            if (!this.acquired && !this.denied) {
                                this._unlock(true);
                                throw e;
                            }
                            interrupted = true;
                        }
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.acquired || this.denied) {
                this._unlock(true);
            }
            return this.acquired && !this.denied;
        }
    }

    protected class ServerCondition {
        protected final ServerLock lock;
        protected final Queue<Owner> queue = new ArrayDeque<Owner>();

        public ServerCondition(ServerLock lock) {
            this.lock = lock;
        }

        public synchronized void addWaiter(Owner waiter) {
            Locking.this.notifyAwaiting(this.lock.lock_name, waiter);
            if (Locking.this.log.isTraceEnabled()) {
                Locking.this.log.trace("Waiter [" + waiter + "] was added for " + this.lock.lock_name);
            }
            this.queue.add(waiter);
        }

        public synchronized void removeWaiter(Owner waiter) {
            Locking.this.notifyAwaited(this.lock.lock_name, waiter);
            if (Locking.this.log.isTraceEnabled()) {
                Locking.this.log.trace("Waiter [" + waiter + "] was removed for " + this.lock.lock_name);
            }
            this.queue.remove(waiter);
        }

        public synchronized void signal(boolean all) {
            if (this.queue.isEmpty() && Locking.this.log.isTraceEnabled()) {
                Locking.this.log.trace("Signal for [" + this.lock.lock_name + "] ignored since, no one is waiting in queue.");
            }
            if (all) {
                Owner entry;
                while ((entry = this.queue.poll()) != null) {
                    Locking.this.notifyAwaited(this.lock.lock_name, entry);
                    if (Locking.this.log.isTraceEnabled()) {
                        Locking.this.log.trace("Signalled " + entry + " for " + this.lock.lock_name);
                    }
                    Locking.this.sendSignalResponse(entry, this.lock.lock_name);
                }
            } else {
                Owner entry = this.queue.poll();
                if (entry != null) {
                    Locking.this.notifyAwaited(this.lock.lock_name, entry);
                    if (Locking.this.log.isTraceEnabled()) {
                        Locking.this.log.trace("Signalled " + entry + " for " + this.lock.lock_name);
                    }
                    Locking.this.sendSignalResponse(entry, this.lock.lock_name);
                }
            }
        }
    }

    protected class ServerLock {
        protected final String lock_name;
        protected Owner current_owner;
        protected final List<Request> queue = new ArrayList<Request>();
        protected final ServerCondition condition;

        public ServerLock(String lock_name) {
            this.lock_name = lock_name;
            this.condition = new ServerCondition(this);
        }

        protected ServerLock(String lock_name, Owner owner) {
            this.lock_name = lock_name;
            this.current_owner = owner;
            this.condition = new ServerCondition(this);
        }

        protected synchronized void handleRequest(Request req) {
            switch (req.type) {
                case GRANT_LOCK: {
                    if (this.current_owner == null) {
                        this.setOwner(req.owner);
                        Locking.this.sendLockResponse(Type.LOCK_GRANTED, req.owner, req.lock_name);
                        break;
                    }
                    if (this.current_owner.equals(req.owner)) {
                        Locking.this.sendLockResponse(Type.LOCK_GRANTED, req.owner, req.lock_name);
                        break;
                    }
                    if (req.is_trylock && req.timeout <= 0L) {
                        Locking.this.sendLockResponse(Type.LOCK_DENIED, req.owner, req.lock_name);
                        break;
                    }
                    this.addToQueue(req);
                    break;
                }
                case RELEASE_LOCK: 
                case LOCK_AWAIT: {
                    if (this.current_owner == null) break;
                    if (this.current_owner.equals(req.owner)) {
                        this.setOwner(null);
                        break;
                    }
                    this.addToQueue(req);
                    break;
                }
                case COND_SIG: {
                    this.condition.signal(false);
                    break;
                }
                case COND_SIG_ALL: {
                    this.condition.signal(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("type " + (Object)((Object)req.type) + " is invalid here");
                }
            }
            this.processQueue();
        }

        protected synchronized void handleView(List<Address> members) {
            if (this.current_owner != null && !members.contains(this.current_owner.getAddress())) {
                Owner tmp = this.current_owner;
                this.setOwner(null);
                if (Locking.this.log.isDebugEnabled()) {
                    Locking.this.log.debug("unlocked \"" + this.lock_name + "\" because owner " + tmp + " left");
                }
            }
            Iterator<Request> it = this.queue.iterator();
            while (it.hasNext()) {
                Request req = it.next();
                if (members.contains(req.owner.getAddress())) continue;
                it.remove();
            }
            it = this.condition.queue.iterator();
            while (it.hasNext()) {
                Owner own = (Owner)((Object)it.next());
                if (members.contains(own.getAddress())) continue;
                it.remove();
            }
            this.processQueue();
        }

        protected void addToQueue(Request req) {
            if (this.queue.isEmpty()) {
                if (req.type == Type.GRANT_LOCK) {
                    this.queue.add(req);
                }
                return;
            }
            switch (req.type) {
                case GRANT_LOCK: {
                    if (this.isRequestPresent(Type.GRANT_LOCK, req.owner)) break;
                    this.queue.add(req);
                    break;
                }
                case RELEASE_LOCK: {
                    this.removeRequest(Type.GRANT_LOCK, req.owner);
                }
            }
        }

        protected boolean isRequestPresent(Type type, Owner owner) {
            for (Request req : this.queue) {
                if (req.type != type || !req.owner.equals(owner)) continue;
                return true;
            }
            return false;
        }

        protected void removeRequest(Type type, Owner owner) {
            Iterator<Request> it = this.queue.iterator();
            while (it.hasNext()) {
                Request req = it.next();
                if (req.type != type || !req.owner.equals(owner)) continue;
                it.remove();
            }
        }

        protected void processQueue() {
            if (this.current_owner == null) {
                while (!this.queue.isEmpty()) {
                    Request req = this.queue.remove(0);
                    if (req.type != Type.GRANT_LOCK) continue;
                    this.setOwner(req.owner);
                    Locking.this.sendLockResponse(Type.LOCK_GRANTED, req.owner, req.lock_name);
                    break;
                }
            }
        }

        protected void setOwner(Owner owner) {
            if (owner == null) {
                if (this.current_owner != null) {
                    Owner tmp = this.current_owner;
                    this.current_owner = null;
                    Locking.this.notifyUnlocked(this.lock_name, tmp);
                }
            } else {
                this.current_owner = owner;
                Locking.this.notifyLocked(this.lock_name, owner);
            }
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.current_owner);
            if (!this.queue.isEmpty()) {
                sb.append(", queue: ");
                for (Request req : this.queue) {
                    sb.append(req.toStringShort()).append(" ");
                }
            }
            return sb.toString();
        }
    }

    protected static enum Type {
        GRANT_LOCK,
        LOCK_GRANTED,
        LOCK_DENIED,
        RELEASE_LOCK,
        CREATE_LOCK,
        DELETE_LOCK,
        LOCK_AWAIT,
        COND_SIG,
        COND_SIG_ALL,
        SIG_RET,
        DELETE_LOCK_AWAIT,
        CREATE_AWAITER,
        DELETE_AWAITER;

    }
}

