/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.Address;

public class Rsp<T> {
    protected boolean received;
    protected boolean suspected;
    protected Address sender;
    protected T retval;
    protected Throwable exception;

    public Rsp(Address sender) {
        this.sender = sender;
    }

    public Rsp(Address sender, boolean suspected) {
        this.sender = sender;
        this.suspected = suspected;
    }

    public Rsp(Address sender, T retval) {
        this.sender = sender;
        this.setValue(retval);
    }

    public Rsp(Address sender, Throwable t) {
        this.sender = sender;
        this.setException(t);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rsp)) {
            return false;
        }
        Rsp other = (Rsp)obj;
        if (this.sender != null) {
            return this.sender.equals(other.sender);
        }
        return other.sender == null;
    }

    public int hashCode() {
        return this.sender != null ? this.sender.hashCode() : 0;
    }

    public T getValue() {
        return this.retval;
    }

    public void setValue(T val) {
        this.retval = val;
        this.received = true;
        this.exception = null;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable t) {
        this.exception = t;
        this.received = true;
        this.retval = null;
    }

    public Address getSender() {
        return this.sender;
    }

    public boolean wasReceived() {
        return this.received;
    }

    public void setReceived(boolean received) {
        this.received = received;
        if (received) {
            this.suspected = false;
        }
    }

    public boolean wasSuspected() {
        return this.suspected;
    }

    public boolean setSuspected(boolean suspected) {
        boolean changed = !this.suspected && suspected;
        this.suspected = suspected;
        if (suspected) {
            this.received = false;
        }
        return changed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sender=").append(this.sender);
        if (this.retval != null) {
            sb.append(", retval=").append(this.retval);
        }
        if (this.exception != null) {
            sb.append(", exception=").append(this.exception);
        }
        sb.append(", received=").append(this.received).append(", suspected=").append(this.suspected);
        return sb.toString();
    }
}

