/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossWSSERoleExtractor {
    public static final String UNCHECKED = "unchecked";

    public static List<String> getRoles(InputStream is, String portName, String operationName) throws ProcessingException {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            Document doc = DocumentUtil.getDocument((InputStream)is);
            NodeList nl = doc.getElementsByTagName("port");
            if (nl != null) {
                Node portNode;
                int len = nl.getLength();
                if (len > 0 && (portNode = JBossWSSERoleExtractor.getNamedNode(nl, portName)) != null) {
                    roles.addAll(JBossWSSERoleExtractor.getRoles(portNode, operationName));
                    return roles;
                }
                return JBossWSSERoleExtractor.getDefaultRoles(doc.getDocumentElement());
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new ProcessingException((Throwable)e1);
        }
        return roles;
    }

    private static Node getNamedNode(NodeList nl, String portName) {
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node name;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !portName.equals((name = n.getAttributes().getNamedItem("name")).getNodeValue())) continue;
            return n;
        }
        return null;
    }

    private static List<String> getRoles(Node node, String operationName) throws ProcessingException {
        ArrayList<String> roles = new ArrayList<String>();
        Element elem = (Element)node;
        NodeList ops = elem.getElementsByTagName("operation");
        if (ops.getLength() > 0) {
            Node opNode = JBossWSSERoleExtractor.getNamedNode(ops, operationName);
            if (opNode != null) {
                return JBossWSSERoleExtractor.getDefaultRoles((Element)opNode);
            }
            return roles;
        }
        NodeList nl = elem.getElementsByTagName("authorize");
        if (nl != null) {
            int len = nl.getLength();
            if (len > 1) {
                throw new ProcessingException("PL00102: Processing Exception:More than one authorize element");
            }
            Node authorize = nl.item(0);
            roles.addAll(JBossWSSERoleExtractor.getRolesFromAuthorize((Element)authorize));
        }
        return roles;
    }

    private static List<String> getDefaultRoles(Element root) throws ProcessingException {
        List<String> roles = new ArrayList<String>();
        NodeList children = root.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = children.item(i);
                if (n.getNodeType() != 1) continue;
                Element newNode = (Element)n;
                if (newNode.getNodeName().equals("port")) {
                    return roles;
                }
                if (newNode.getNodeName().equals("authorize")) {
                    return JBossWSSERoleExtractor.getRolesFromAuthorize(newNode);
                }
                roles = JBossWSSERoleExtractor.getDefaultRoles(newNode);
            }
        }
        return JBossWSSERoleExtractor.validate(roles);
    }

    private static List<String> validate(List<String> roles) throws ProcessingException {
        if (roles.contains(UNCHECKED) && roles.size() > 1) {
            throw new ProcessingException("PL00102: Processing Exception:unchecked and role(s) cannot be together");
        }
        return roles;
    }

    private static List<String> getRolesFromAuthorize(Element authorize) throws ProcessingException {
        ArrayList<String> roles = new ArrayList<String>();
        NodeList children = authorize.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            String nodeName = child.getNodeName();
            if (UNCHECKED.equals(nodeName)) {
                roles.add(nodeName);
                continue;
            }
            if (!"role".equals(nodeName)) continue;
            roles.add(child.getChildNodes().item(0).getNodeValue());
        }
        return JBossWSSERoleExtractor.validate(roles);
    }
}

