/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr;

import java.util.HashMap;
import java.util.Map;
import org.apache.ws.scout.registry.ConnectionFactoryImpl;
import org.jboss.as.jaxr.scout.SaajTransport;

public interface JAXRConstants {
    public static final String SUBSYSTEM_NAME = "jaxr";
    public static final String RESOURCE_NAME = "org.jboss.as.jaxr.LocalDescriptions";
    public static final String SYSPROP_SCOUT_CONNECTION_FACTORY_CLASS = "javax.xml.registry.ConnectionFactoryClass";
    public static final String SYSPROP_SCOUT_TRANSPORT_CLASS = "scout.proxy.transportClass";
    public static final String SYSPROP_PUBLISH_URL = "jaxr.publish.url";
    public static final String SYSPROP_QUERY_URL = "jaxr.query.url";
    public static final String DEFAULT_SCOUT_CONNECTION_FACTORY_CLASS = ConnectionFactoryImpl.class.getName();
    public static final String DEFAULT_SCOUT_TRANSPORT_CLASS = SaajTransport.class.getName();

    public static enum Element {
        UNKNOWN(null),
        CONNECTION_FACTORY("connection-factory"),
        JUDDI_SERVER("juddi-server");

        private final String name;
        private static final Map<String, Element> MAP;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Attribute {
        UNKNOWN(null),
        JNDI_NAME("jndi-name"),
        QUERY_URL("query-url"),
        PUBLISH_URL("publish-url");

        private final String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Attribute forName(String localName) {
            Attribute element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        public String toString() {
            return this.getLocalName();
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute element : Attribute.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Namespace {
        UNKNOWN(null),
        JAXR_1_0("urn:jboss:domain:jaxr:1.0");

        public static final Namespace CURRENT;
        private final String name;
        private static final Map<String, Namespace> MAP;

        private Namespace(String name) {
            this.name = name;
        }

        public String getUriString() {
            return this.name;
        }

        public static Namespace forUri(String uri) {
            Namespace element = MAP.get(uri);
            return element == null ? UNKNOWN : element;
        }

        static {
            CURRENT = JAXR_1_0;
            HashMap<String, Namespace> map = new HashMap<String, Namespace>();
            for (Namespace namespace : Namespace.values()) {
                String name = namespace.getUriString();
                if (name == null) continue;
                map.put(name, namespace);
            }
            MAP = map;
        }
    }
}

