/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.JAXRConstants;
import org.jboss.as.jaxr.extension.JAXRDependencyProcessor;
import org.jboss.as.jaxr.extension.JAXRWriteAttributeHandler;
import org.jboss.as.jaxr.extension.SecurityActions;
import org.jboss.as.jaxr.service.JAXRConfigurationService;
import org.jboss.as.jaxr.service.JAXRConnectionFactoryService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class JAXRSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private final JAXRConfiguration config;

    JAXRSubsystemAdd(JAXRConfiguration config) {
        this.config = config;
    }

    static ModelNode createAddSubsystemOperation() {
        ModelNode addop = new ModelNode();
        addop.get("operation").set("add");
        addop.get("address").add("subsystem", "jaxr");
        return addop;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (String attr : JAXRConfiguration.REQUIRED_ATTRIBUTES) {
            ModelNode node = operation.get(attr);
            if (!node.isDefined()) {
                throw new IllegalStateException("Attribute not defined: " + attr);
            }
            JAXRWriteAttributeHandler.applyUpdateToConfig(this.config, attr, node);
            model.get(attr).set(node);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verifyHandler, final List<ServiceController<?>> newControllers) throws OperationFailedException {
        SecurityActions.setSystemProperty("scout.proxy.transportClass", JAXRConstants.DEFAULT_SCOUT_TRANSPORT_CLASS);
        SecurityActions.setSystemProperty("javax.xml.registry.ConnectionFactoryClass", JAXRConstants.DEFAULT_SCOUT_CONNECTION_FACTORY_CLASS);
        SecurityActions.setSystemProperty("jaxr.publish.url", this.config.getPublishURL());
        SecurityActions.setSystemProperty("jaxr.query.url", this.config.getQueryURL());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 5632, (DeploymentUnitProcessor)new JAXRDependencyProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceTarget serviceTarget = context.getServiceTarget();
                newControllers.add(JAXRConfigurationService.addService(serviceTarget, JAXRSubsystemAdd.this.config, new ServiceListener[]{verifyHandler}));
                newControllers.add(JAXRConnectionFactoryService.addService(serviceTarget, new ServiceListener[]{verifyHandler}));
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

