/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.jaxr.JAXRConstants;
import org.jboss.as.jaxr.extension.JAXRSubsystemAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JAXRSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addop = JAXRSubsystemAdd.createAddSubsystemOperation();
        while (reader.hasNext() && reader.nextTag() != 2) {
            block0 : switch (JAXRConstants.Namespace.forUri(reader.getNamespaceURI())) {
                case JAXR_1_0: {
                    JAXRConstants.Element element = JAXRConstants.Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONNECTION_FACTORY: {
                            this.parseBinding(reader, addop);
                            break block0;
                        }
                        case JUDDI_SERVER: {
                            this.parseJUDDIServer(reader, addop);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        operations.add(addop);
    }

    private void parseBinding(XMLExtendedStreamReader reader, ModelNode addop) throws XMLStreamException {
        String jndiName = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            JAXRConstants.Attribute attribute = JAXRConstants.Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case JNDI_NAME: {
                    jndiName = attrValue;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (jndiName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(JAXRConstants.Attribute.JNDI_NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addop.get("connection-factory").set(jndiName);
    }

    private void parseJUDDIServer(XMLExtendedStreamReader reader, ModelNode addop) throws XMLStreamException {
        String publishURL = null;
        String queryURL = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            JAXRConstants.Attribute attribute = JAXRConstants.Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PUBLISH_URL: {
                    publishURL = attrValue;
                    continue block4;
                }
                case QUERY_URL: {
                    queryURL = attrValue;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (publishURL == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(JAXRConstants.Attribute.PUBLISH_URL));
        }
        if (queryURL == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(JAXRConstants.Attribute.QUERY_URL));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addop.get("publish-url").set(publishURL);
        addop.get("query-url").set(queryURL);
    }
}

