/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.as.jmx.SecurityActions;
import org.jboss.as.server.jmx.MBeanServerPlugin;
import org.jboss.as.server.jmx.PluggableMBeanServer;

class PluggableMBeanServerImpl
implements PluggableMBeanServer {
    private final MBeanServer rootMBeanServer;
    private final Set<MBeanServerPlugin> delegates = new CopyOnWriteArraySet<MBeanServerPlugin>();

    PluggableMBeanServerImpl(MBeanServer rootMBeanServer) {
        this.rootMBeanServer = new TcclMBeanServer(rootMBeanServer);
    }

    public void addPlugin(MBeanServerPlugin delegate) {
        this.delegates.add(delegate);
    }

    public void removePlugin(MBeanServerPlugin delegate) {
        this.delegates.remove(delegate);
    }

    private MBeanServer findDelegate(ObjectName name) {
        if (name == null) {
            throw new IllegalArgumentException("Object name can't be null");
        }
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                if (!delegate.accepts(name)) continue;
                return delegate;
            }
        }
        return this.rootMBeanServer;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.findDelegate(name).addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.findDelegate(name).addNotificationListener(name, listener, filter, handback);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.findDelegate(name).createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.findDelegate(name).createMBean(className, name, loaderName, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.findDelegate(name).createMBean(className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.findDelegate(name).createMBean(className, name);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
        return this.findDelegate(name).deserialize(name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.rootMBeanServer.deserialize(className, data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
        return this.rootMBeanServer.deserialize(className, loaderName, data);
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.findDelegate(name).getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.findDelegate(name).getAttributes(name, attributes);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.findDelegate(loaderName).getClassLoader(loaderName);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.findDelegate(mbeanName).getClassLoaderFor(mbeanName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return this.rootMBeanServer.getClassLoaderRepository();
    }

    public String getDefaultDomain() {
        return this.rootMBeanServer.getDefaultDomain();
    }

    public String[] getDomains() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                String[] domains = delegate.getDomains();
                if (domains.length <= 0) continue;
                result.addAll(Arrays.asList(domains));
            }
        }
        result.addAll(Arrays.asList(this.rootMBeanServer.getDomains()));
        return result.toArray(new String[result.size()]);
    }

    public Integer getMBeanCount() {
        int i = 0;
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                i += delegate.getMBeanCount().intValue();
            }
        }
        return i += this.rootMBeanServer.getMBeanCount().intValue();
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.findDelegate(name).getMBeanInfo(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.findDelegate(name).getObjectInstance(name);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.rootMBeanServer.instantiate(className, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.rootMBeanServer.instantiate(className, loaderName, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.rootMBeanServer.instantiate(className, loaderName);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.rootMBeanServer.instantiate(className);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            return this.findDelegate(name).invoke(name, operationName, params, signature);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.findDelegate(name).isInstanceOf(name, className);
    }

    public boolean isRegistered(ObjectName name) {
        return this.findDelegate(name).isRegistered(name);
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                result.addAll(delegate.queryMBeans(name, query));
            }
        }
        result.addAll(this.rootMBeanServer.queryMBeans(name, query));
        return result;
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                result.addAll(delegate.queryNames(name, query));
            }
        }
        result.addAll(this.rootMBeanServer.queryNames(name, query));
        return result;
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.findDelegate(name).registerMBean(object, name);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.findDelegate(name).removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.findDelegate(name).removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.findDelegate(name).removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.findDelegate(name).removeNotificationListener(name, listener);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.findDelegate(name).setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.findDelegate(name).setAttributes(name, attributes);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.findDelegate(name).unregisterMBean(name);
    }

    private class TcclMBeanServer
    implements MBeanServer {
        private final MBeanServer delegate;

        public TcclMBeanServer(MBeanServer delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.addNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.addNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
            return this.delegate.createMBean(className, name, params, signature);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                ObjectInstance objectInstance = this.delegate.createMBean(className, name, loaderName, params, signature);
                return objectInstance;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                ObjectInstance objectInstance = this.delegate.createMBean(className, name, loaderName);
                return objectInstance;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
            return this.delegate.createMBean(className, name);
        }

        @Override
        public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
            return this.delegate.deserialize(name, data);
        }

        @Override
        public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
            return this.delegate.deserialize(className, data);
        }

        @Override
        public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
            return this.delegate.deserialize(className, loaderName, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                Object object = this.delegate.getAttribute(name, attribute);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                AttributeList attributeList = this.delegate.getAttributes(name, attributes);
                return attributeList;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
            return this.delegate.getClassLoader(loaderName);
        }

        @Override
        public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
            return this.delegate.getClassLoaderFor(mbeanName);
        }

        @Override
        public ClassLoaderRepository getClassLoaderRepository() {
            return this.delegate.getClassLoaderRepository();
        }

        @Override
        public String getDefaultDomain() {
            return this.delegate.getDefaultDomain();
        }

        @Override
        public String[] getDomains() {
            return this.delegate.getDomains();
        }

        @Override
        public Integer getMBeanCount() {
            return this.delegate.getMBeanCount();
        }

        @Override
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
            return this.delegate.getMBeanInfo(name);
        }

        @Override
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
            return this.delegate.getObjectInstance(name);
        }

        @Override
        public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
            return this.delegate.instantiate(className, params, signature);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                Object object = this.delegate.instantiate(className, loaderName, params, signature);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                Object object = this.delegate.instantiate(className, loaderName);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public Object instantiate(String className) throws ReflectionException, MBeanException {
            return this.delegate.instantiate(className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                Object object = this.delegate.invoke(name, operationName, params, signature);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
            return this.delegate.isInstanceOf(name, className);
        }

        @Override
        public boolean isRegistered(ObjectName name) {
            return this.delegate.isRegistered(name);
        }

        @Override
        public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
            return this.delegate.queryMBeans(name, query);
        }

        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
            return this.delegate.queryNames(name, query);
        }

        @Override
        public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
            return this.delegate.registerMBean(object, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.setAttribute(name, attribute);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                AttributeList attributeList = this.delegate.setAttributes(name, attributes);
                return attributeList;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
            this.delegate.unregisterMBean(name);
        }

        private ClassLoader pushClassLoader(ObjectName name) throws InstanceNotFoundException {
            ClassLoader mbeanCl = this.delegate.getClassLoaderFor(name);
            return SecurityActions.setThreadContextClassLoader(mbeanCl);
        }

        private ClassLoader pushClassLoaderByName(ObjectName loaderName) throws InstanceNotFoundException {
            ClassLoader mbeanCl = this.delegate.getClassLoader(loaderName);
            return SecurityActions.setThreadContextClassLoader(mbeanCl);
        }

        private void resetClassLoader(ClassLoader cl) {
            SecurityActions.resetThreadContextClassLoader(cl);
        }
    }
}

