/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.container.PicoContainerFactory;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.lifecycle.IServantLifecyle;
import org.jacorb.notification.lifecycle.ServantLifecyleControl;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.IEventChannel;
import org.jacorb.notification.servant.ITypedAdmin;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;

public abstract class AbstractAdmin
implements QoSAdminOperations,
FilterAdminOperations,
FilterStage,
IServantLifecyle,
JMXManageable {
    protected static final InterFilterGroupOperator DEFAULT_FILTER_GROUP_OPERATOR = InterFilterGroupOperator.AND_OP;
    private final DisposableManager disposables_ = new DisposableManager();
    private final Integer id_;
    private InterFilterGroupOperator filterGroupOperator_;
    protected final MutablePicoContainer container_;
    private final FilterManager filterManager_;
    private final WeakReference eventChannelReference_;
    private final QoSPropertySet qosSettings_;
    private final MessageFactory messageFactory_;
    protected final OfferManager offerManager_;
    protected final SubscriptionManager subscriptionManager_;
    protected final Logger logger_;
    private final ORB orb_;
    private final POA poa_;
    protected final java.lang.Object modifyProxiesLock_ = new java.lang.Object();
    protected final Map pullServants_ = new HashMap();
    protected final Map pushServants_ = new HashMap();
    private final AtomicInteger proxyIdPool_ = new AtomicInteger(0);
    private final AtomicBoolean disposed_ = new AtomicBoolean(false);
    private final List proxyEventListener_ = new ArrayList();
    private final int channelID_;
    private final String parentMBean_;
    private JMXManageable.JMXCallback jmxCallback_;
    protected final ServantLifecyleControl servantLifecycle_;

    protected AbstractAdmin(IEventChannel iEventChannel, ORB oRB, POA pOA, Configuration configuration, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        this.parentMBean_ = iEventChannel.getChannelMBean();
        this.container_ = iEventChannel.getContainer();
        this.id_ = new Integer(iEventChannel.getAdminID());
        this.orb_ = oRB;
        this.poa_ = pOA;
        this.messageFactory_ = messageFactory;
        this.filterManager_ = new FilterManager();
        this.eventChannelReference_ = new WeakReference<EventChannel>(iEventChannel.getEventChannel());
        this.channelID_ = iEventChannel.getChannelID();
        this.logger_ = configuration.getLogger(this.getClass().getName());
        this.qosSettings_ = new QoSPropertySet(configuration, 1);
        this.offerManager_ = offerManager;
        this.subscriptionManager_ = subscriptionManager;
        this.servantLifecycle_ = new ServantLifecyleControl((IServantLifecyle)this, configuration);
    }

    public final void registerDisposable(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public void setInterFilterGroupOperator(InterFilterGroupOperator interFilterGroupOperator) {
        this.filterGroupOperator_ = interFilterGroupOperator;
    }

    public final POA getPOA() {
        return this.poa_;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory_;
    }

    int getProxyID() {
        return this.proxyIdPool_.getAndIncrement();
    }

    public List getFilters() {
        return this.filterManager_.getFilters();
    }

    public int add_filter(Filter filter) {
        return this.filterManager_.add_filter(filter);
    }

    public void remove_filter(int n) throws FilterNotFound {
        this.filterManager_.remove_filter(n);
    }

    public Filter get_filter(int n) throws FilterNotFound {
        return this.filterManager_.get_filter(n);
    }

    public int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public final InterFilterGroupOperator MyOperator() {
        return this.filterGroupOperator_;
    }

    public final EventChannel MyChannel() {
        return (EventChannel)this.eventChannelReference_.get();
    }

    public final int MyID() {
        return this.getID();
    }

    public final int getChannelID() {
        return this.channelID_;
    }

    public Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("AbstractAdmin.set_qos: " + this.qosSettings_);
        }
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(propertyArray);
    }

    public void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, namedPropertyRangeSeqHolder);
    }

    public final void destroy() {
        this.checkDestroyStatus();
        this.container_.dispose();
        List list = this.container_.getComponentInstancesOfType(IContainer.class);
        for (IContainer iContainer : list) {
            iContainer.destroy();
        }
    }

    private void checkDestroyStatus() throws OBJECT_NOT_EXIST {
        if (!this.disposed_.compareAndSet(false, true)) {
            throw new OBJECT_NOT_EXIST();
        }
    }

    public void dispose() {
        this.logger_.info("destroy Admin " + this.MyID());
        this.deactivate();
        this.remove_all_filters();
        this.disposables_.dispose();
        this.proxyEventListener_.clear();
    }

    public final Object activate() {
        return this.servantLifecycle_.activate();
    }

    public final void deactivate() {
        this.servantLifecycle_.deactivate();
    }

    public Integer getID() {
        return this.id_;
    }

    public boolean isDestroyed() {
        return this.disposed_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCreateProxyRequestEvent() throws AdminLimitExceeded {
        List list = this.proxyEventListener_;
        synchronized (list) {
            ProxyEvent proxyEvent = new ProxyEvent(this);
            for (ProxyEventListener proxyEventListener : this.proxyEventListener_) {
                proxyEventListener.actionProxyCreationRequest(proxyEvent);
            }
        }
    }

    public boolean hasLifetimeFilter() {
        return false;
    }

    public boolean hasPriorityFilter() {
        return false;
    }

    public MappingFilter getLifetimeFilter() {
        throw new UnsupportedOperationException();
    }

    public MappingFilter getPriorityFilter() {
        throw new UnsupportedOperationException();
    }

    public String getInterFilterGroupOperator() {
        return this.filterGroupOperator_.value() == 0 ? "AND_OP" : "OR_OP";
    }

    public boolean hasInterFilterGroupOperatorOR() {
        return this.filterGroupOperator_.value() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractProxy getProxy(int n) throws ProxyNotFound {
        AbstractProxy abstractProxy;
        Integer n2 = new Integer(n);
        java.lang.Object object = this.modifyProxiesLock_;
        synchronized (object) {
            abstractProxy = (AbstractProxy)this.pullServants_.get(n2);
            if (abstractProxy == null) {
                abstractProxy = (AbstractProxy)this.pushServants_.get(n2);
            }
        }
        if (abstractProxy == null) {
            throw new ProxyNotFound("The proxy with ID=" + n + " does not exist");
        }
        if (!abstractProxy.isIDPublic()) {
            throw new ProxyNotFound("The proxy with ID=" + n + " is a EventStyle proxy and therefor not accessible by ID");
        }
        return abstractProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] get_all_notify_proxies(Map map, java.lang.Object object) {
        ArrayList arrayList = new ArrayList();
        java.lang.Object object2 = object;
        synchronized (object2) {
            for (Map.Entry entry : map.entrySet()) {
                if (!((AbstractProxy)entry.getValue()).isIDPublic()) continue;
                arrayList.add(entry.getKey());
            }
        }
        object2 = new int[arrayList.size()];
        for (int i = 0; i < ((java.lang.Object)object2).length; ++i) {
            object2[i] = (Integer)arrayList.get(i);
        }
        return object2;
    }

    protected void configureQoS(AbstractProxy abstractProxy) throws UnsupportedQoS {
        this.logger_.debug("configure new AbstractProxy with " + this.qosSettings_);
        abstractProxy.set_qos(this.qosSettings_.get_qos());
    }

    protected void configureInterFilterGroupOperator(AbstractProxy abstractProxy) {
        if (this.filterGroupOperator_.value() == 1) {
            abstractProxy.setInterFilterGroupOperatorOR(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyEventListener(ProxyEventListener proxyEventListener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.add(proxyEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProxyEventListener(ProxyEventListener proxyEventListener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.remove(proxyEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireProxyRemoved(AbstractProxy abstractProxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator iterator = this.proxyEventListener_.iterator();
            ProxyEvent proxyEvent = new ProxyEvent(abstractProxy);
            while (iterator.hasNext()) {
                ((ProxyEventListener)iterator.next()).actionProxyDisposed(proxyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProxyCreated(AbstractProxy abstractProxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator iterator = this.proxyEventListener_.iterator();
            ProxyEvent proxyEvent = new ProxyEvent(abstractProxy);
            while (iterator.hasNext()) {
                ((ProxyEventListener)iterator.next()).actionProxyCreated(proxyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProxyToMap(final AbstractProxy abstractProxy, final Map map, final java.lang.Object object) {
        java.lang.Object object2 = object;
        synchronized (object2) {
            map.put(abstractProxy.getID(), abstractProxy);
            this.fireProxyCreated(abstractProxy);
        }
        abstractProxy.registerDisposable(new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                java.lang.Object object2 = object;
                synchronized (object2) {
                    map.remove(abstractProxy.getID());
                    AbstractAdmin.this.fireProxyRemoved(abstractProxy);
                }
            }
        });
    }

    protected MutablePicoContainer newContainerForNotifyStyleProxy() {
        return this.newContainerForProxy(true);
    }

    protected MutablePicoContainer newContainerForEventStyleProxy() {
        return this.newContainerForProxy(false);
    }

    protected MutablePicoContainer newContainerForTypedProxy(String string) {
        MutablePicoContainer mutablePicoContainer = this.newContainerForNotifyStyleProxy();
        IAdmin iAdmin = (IAdmin)mutablePicoContainer.getComponentInstanceOfType(IAdmin.class);
        ITypedAdminImpl iTypedAdminImpl = new ITypedAdminImpl(iAdmin, mutablePicoContainer, string);
        mutablePicoContainer.registerComponentInstance(ITypedAdmin.class, (java.lang.Object)iTypedAdminImpl);
        return mutablePicoContainer;
    }

    private MutablePicoContainer newContainerForProxy(boolean bl) {
        int n = this.getProxyID();
        return this.newContainerForProxy(n, bl);
    }

    private MutablePicoContainer newContainerForProxy(final int n, final boolean bl) {
        final MutablePicoContainer mutablePicoContainer = PicoContainerFactory.createChildContainer(this.container_);
        IAdmin iAdmin = new IAdmin(){

            public MutablePicoContainer getContainer() {
                return mutablePicoContainer;
            }

            public int getProxyID() {
                return n;
            }

            public boolean isIDPublic() {
                return bl;
            }

            public void destroy() {
                AbstractAdmin.this.container_.removeChildContainer((PicoContainer)mutablePicoContainer);
            }

            public String getAdminMBean() {
                return AbstractAdmin.this.getJMXObjectName();
            }
        };
        mutablePicoContainer.registerComponentInstance(IAdmin.class, (java.lang.Object)iAdmin);
        return mutablePicoContainer;
    }

    public final String getJMXObjectName() {
        return this.parentMBean_ + ", admin=" + this.getMBeanName();
    }

    public final String getMBeanName() {
        return this.getMBeanType() + "-" + this.getID();
    }

    protected abstract String getMBeanType();

    public String[] getJMXNotificationTypes() {
        return new String[0];
    }

    public final void setJMXCallback(JMXManageable.JMXCallback jMXCallback) {
        this.jmxCallback_ = jMXCallback;
    }

    protected final void sendNotification(String string, String string2) {
        if (this.jmxCallback_ != null) {
            this.jmxCallback_.sendJMXNotification(string, string2);
        }
    }

    private static final class ITypedAdminImpl
    implements ITypedAdmin {
        private final IAdmin admin_;
        private final MutablePicoContainer container_;
        private final String supportedInterface_;

        private ITypedAdminImpl(IAdmin iAdmin, MutablePicoContainer mutablePicoContainer, String string) {
            this.admin_ = iAdmin;
            this.container_ = mutablePicoContainer;
            this.supportedInterface_ = string;
        }

        public String getSupportedInterface() {
            return this.supportedInterface_;
        }

        public int getProxyID() {
            return this.admin_.getProxyID();
        }

        public boolean isIDPublic() {
            return this.admin_.isIDPublic();
        }

        public MutablePicoContainer getContainer() {
            return this.admin_.getContainer();
        }

        public void destroy() {
            this.container_.unregisterComponent(ITypedAdmin.class);
            this.admin_.destroy();
        }

        public String getAdminMBean() {
            return this.admin_.getAdminMBean();
        }
    }
}

