/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.WarDeploymentProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.msc.service.ServiceName;

public class WebInitializeInOrderProcessor
implements DeploymentUnitProcessor {
    private final String defaultHost;

    public WebInitializeInOrderProcessor(String defaultHost) {
        if (defaultHost == null) {
            throw new IllegalArgumentException("null default host");
        }
        this.defaultHost = defaultHost;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return;
        }
        String hostName = WarDeploymentProcessor.hostNameOfDeployment(metaData, this.defaultHost);
        this.processDeployment(hostName, metaData, deploymentUnit);
    }

    private void processDeployment(String hostName, WarMetaData metaData, DeploymentUnit deploymentUnit) {
        String pathName = WarDeploymentProcessor.pathNameOfDeployment(deploymentUnit, metaData.getMergedJBossWebMetaData());
        ServiceName deploymentServiceName = WebSubsystemServices.deploymentServiceName(hostName, pathName);
        ServiceName realmServiceName = deploymentServiceName.append(new String[]{"realm"});
        deploymentUnit.addToAttachmentList(Attachments.INITIALISE_IN_ORDER_SERVICES, (Object)deploymentServiceName);
        deploymentUnit.addToAttachmentList(Attachments.INITIALISE_IN_ORDER_SERVICES, (Object)realmServiceName);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

