/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheException;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.decorators.ReadOnlyStore;
import org.infinispan.loaders.decorators.SingletonStore;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheLoaderManagerImpl
implements CacheLoaderManager {
    Configuration configuration;
    CacheLoaderManagerConfig clmConfig;
    AdvancedCache<Object, Object> cache;
    StreamingMarshaller m;
    CacheLoader loader;
    InvocationContextContainer icc;
    private static final Log log = LogFactory.getLog(CacheLoaderManagerImpl.class);

    @Inject
    public void inject(AdvancedCache<Object, Object> cache, @ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, Configuration configuration, InvocationContextContainer icc) {
        this.cache = cache;
        this.m = marshaller;
        this.configuration = configuration;
        this.icc = icc;
    }

    @Override
    public CacheLoader getCacheLoader() {
        return this.loader;
    }

    @Override
    public final CacheStore getCacheStore() {
        if (this.loader != null && this.loader instanceof CacheStore) {
            return (CacheStore)this.loader;
        }
        return null;
    }

    @Override
    public void purge() {
        CacheStore cs = this.getCacheStore();
        if (cs != null) {
            try {
                cs.clear();
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Unable to purge cache store", e);
            }
        }
    }

    private void purgeLoaders(boolean force) throws Exception {
        CacheStore cs = this.getCacheStore();
        if (cs != null) {
            if (cs instanceof ChainingCacheStore && !force) {
                ((ChainingCacheStore)this.loader).purgeIfNecessary();
            } else {
                CacheStoreConfig first = (CacheStoreConfig)this.clmConfig.getFirstCacheLoaderConfig();
                if (force || first != null && first.isPurgeOnStartup().booleanValue()) {
                    cs.clear();
                }
            }
        }
    }

    @Override
    public boolean isUsingPassivation() {
        return this.isEnabled() ? this.clmConfig.isPassivation() : false;
    }

    @Override
    public boolean isShared() {
        return this.isEnabled() ? this.clmConfig.isShared() : false;
    }

    @Override
    public boolean isFetchPersistentState() {
        return this.isEnabled() ? this.clmConfig.isFetchPersistentState() : false;
    }

    @Override
    @Start(priority=10)
    public void start() {
        this.clmConfig = this.configuration.getCacheLoaderManagerConfig();
        if (this.clmConfig != null) {
            try {
                this.loader = this.createCacheLoader();
                if (this.loader != null) {
                    this.loader.start();
                }
                this.purgeLoaders(false);
            }
            catch (Exception e) {
                throw new CacheException("Unable to start cache loaders", e);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.clmConfig != null;
    }

    @Override
    @Start(priority=56)
    public void preload() {
        if (this.loader != null && this.clmConfig.isPreload().booleanValue()) {
            Set<InternalCacheEntry> state;
            long start = 0L;
            boolean debugTiming = log.isDebugEnabled();
            if (debugTiming) {
                start = System.nanoTime();
                log.debugf("Preloading transient state from cache loader %s", this.loader);
            }
            try {
                state = this.loadState();
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Unable to preload!", e);
            }
            for (InternalCacheEntry e : state) {
                if (this.clmConfig.isShared().booleanValue() || !(this.loader instanceof ChainingCacheStore)) {
                    this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STATUS_CHECK, Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK, Flag.SKIP_CACHE_STORE, Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_INDEXING).put(e.getKey(), e.getValue(), e.getLifespan(), TimeUnit.MILLISECONDS, e.getMaxIdle(), TimeUnit.MILLISECONDS);
                    continue;
                }
                this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STATUS_CHECK, Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK, Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_INDEXING).put(e.getKey(), e.getValue(), e.getLifespan(), TimeUnit.MILLISECONDS, e.getMaxIdle(), TimeUnit.MILLISECONDS);
            }
            if (debugTiming) {
                long stop = System.nanoTime();
                log.debugf("Preloaded %s keys in %s", state.size(), Util.prettyPrintTime(stop - start, TimeUnit.NANOSECONDS));
            }
        }
    }

    private Set<InternalCacheEntry> loadState() throws CacheLoaderException {
        Set<InternalCacheEntry> state;
        int ne = -1;
        if (this.configuration.getEvictionStrategy().isEnabled()) {
            ne = this.configuration.getEvictionMaxEntries();
        }
        switch (ne) {
            case -1: {
                state = this.loader.loadAll();
                break;
            }
            case 0: {
                state = Collections.emptySet();
                break;
            }
            default: {
                state = this.loader.load(ne);
            }
        }
        return state;
    }

    @Override
    @Stop
    public void stop() {
        if (this.loader != null) {
            try {
                InvocationContext ctx;
                CacheStore store = this.getCacheStore();
                if (store != null && (ctx = this.icc.getInvocationContext(false)) != null && ctx.hasFlag(Flag.REMOVE_DATA_ON_STOP)) {
                    if (log.isTraceEnabled()) {
                        log.trace("Requested removal of data on stop, so clear cache store");
                    }
                    store.clear();
                }
                this.loader.stop();
            }
            catch (CacheLoaderException e) {
                throw new CacheException(e);
            }
            finally {
                this.loader = null;
            }
        }
    }

    CacheLoader createCacheLoader() throws Exception {
        CacheLoader tmpLoader;
        if (this.clmConfig.usingChainingCacheLoader()) {
            ChainingCacheStore ccl;
            tmpLoader = ccl = new ChainingCacheStore();
            int numLoadersWithFetchPersistentState = 0;
            for (CacheLoaderConfig cfg : this.clmConfig.getCacheLoaderConfigs()) {
                if (cfg instanceof CacheStoreConfig) {
                    if (((CacheStoreConfig)cfg).isFetchPersistentState().booleanValue()) {
                        ++numLoadersWithFetchPersistentState;
                    }
                    if (numLoadersWithFetchPersistentState > 1) {
                        throw new Exception("Invalid cache loader configuration!!  Only ONE cache loader may have fetchPersistentState set to true.  Cache will not start!");
                    }
                    this.assertNotSingletonAndShared((CacheStoreConfig)cfg);
                }
                CacheLoader l = this.createCacheLoader(cfg, this.cache);
                ccl.addCacheLoader(l, cfg);
            }
        } else {
            CacheLoaderConfig cfg = this.clmConfig.getFirstCacheLoaderConfig();
            if (cfg != null) {
                tmpLoader = this.createCacheLoader(cfg, this.cache);
                if (cfg instanceof CacheStoreConfig) {
                    this.assertNotSingletonAndShared((CacheStoreConfig)cfg);
                }
            } else {
                return null;
            }
        }
        ReflectionUtil.setValue(this.clmConfig, "accessible", true);
        return tmpLoader;
    }

    CacheLoader createCacheLoader(CacheLoaderConfig cfg, AdvancedCache<Object, Object> cache) throws Exception {
        CacheLoader tmpLoader = (CacheLoader)Util.getInstance(cfg.getCacheLoaderClassName(), cache.getClassLoader());
        if (tmpLoader != null) {
            if (cfg instanceof CacheStoreConfig) {
                SingletonStoreConfig ssc;
                CacheStore tmpStore = (CacheStore)tmpLoader;
                CacheStoreConfig cfg2 = (CacheStoreConfig)cfg;
                if (cfg2.getAsyncStoreConfig().isEnabled().booleanValue()) {
                    tmpStore = new AsyncStore(tmpStore, cfg2.getAsyncStoreConfig());
                    tmpLoader = tmpStore;
                }
                if (cfg2.isIgnoreModifications().booleanValue()) {
                    tmpStore = new ReadOnlyStore(tmpStore);
                    tmpLoader = tmpStore;
                }
                if ((ssc = cfg2.getSingletonStoreConfig()) != null && ssc.isSingletonStoreEnabled().booleanValue()) {
                    tmpStore = new SingletonStore(tmpStore, cache, ssc);
                    tmpLoader = tmpStore;
                }
            }
            tmpLoader.init(cfg, cache, this.m);
        }
        return tmpLoader;
    }

    void assertNotSingletonAndShared(CacheStoreConfig cfg) {
        SingletonStoreConfig ssc = cfg.getSingletonStoreConfig();
        if (ssc != null && ssc.isSingletonStoreEnabled().booleanValue() && this.clmConfig.isShared().booleanValue()) {
            throw new ConfigurationException("Invalid cache loader configuration!!  If a cache loader is configured as a singleton, the cache loader cannot be shared in a cluster!");
        }
    }
}

