/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;

public class DistributionResponseGenerator
implements ResponseGenerator {
    DistributionManager distributionManager;

    @Inject
    public void inject(DistributionManager distributionManager) {
        this.distributionManager = distributionManager;
    }

    @Override
    public Response getResponse(CacheRpcCommand command, Object returnValue) {
        if (command.getCommandId() == 16) {
            if (returnValue == null) {
                return null;
            }
            ClusteredGetCommand clusteredGet = (ClusteredGetCommand)command;
            if (this.distributionManager.isAffectedByRehash(clusteredGet.getKey())) {
                return UnsureResponse.INSTANCE;
            }
            return new SuccessfulResponse(returnValue);
        }
        if (command instanceof SingleRpcCommand) {
            SingleRpcCommand src = (SingleRpcCommand)command;
            ReplicableCommand c = src.getCommand();
            byte commandId = c.getCommandId();
            if (c instanceof WriteCommand) {
                if (returnValue == null) {
                    return null;
                }
                WriteCommand wc = (WriteCommand)c;
                return this.handleWriteCommand(wc, returnValue);
            }
            if (commandId == 20 || commandId == 19) {
                return new SuccessfulResponse(returnValue);
            }
            if (c.isReturnValueExpected()) {
                if (returnValue == null) {
                    return null;
                }
                return new SuccessfulResponse(returnValue);
            }
        } else if (command.isReturnValueExpected()) {
            return new SuccessfulResponse(returnValue);
        }
        return null;
    }

    protected Response handleWriteCommand(WriteCommand wc, Object returnValue) {
        if (wc.isSuccessful()) {
            return wc.isReturnValueExpected() ? new SuccessfulResponse(returnValue) : null;
        }
        return UnsuccessfulResponse.INSTANCE;
    }
}

