/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.OwnableReentrantLock;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.infinispan.util.concurrent.locks.containers.OwnableReentrantPerEntryLockContainer;
import org.infinispan.util.concurrent.locks.containers.OwnableReentrantStripedLockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantStripedLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;

@MBean(objectName="LockManager", description="Manager that handles MVCC locks for entries")
public class LockManagerImpl
implements LockManager {
    protected Configuration configuration;
    protected volatile LockContainer lockContainer;
    private TransactionManager transactionManager;
    private static final Log log = LogFactory.getLog(LockManagerImpl.class);
    protected static final boolean trace = log.isTraceEnabled();
    private static final String ANOTHER_THREAD = "(another thread)";

    @Inject
    public void injectDependencies(Configuration configuration, TransactionManager transactionManager) {
        this.configuration = configuration;
        this.transactionManager = transactionManager;
    }

    @Start(priority=8)
    public void startLockManager() {
        this.lockContainer = this.configuration.isUseLockStriping() ? (this.transactionManager == null ? new ReentrantStripedLockContainer(this.configuration.getConcurrencyLevel()) : new OwnableReentrantStripedLockContainer(this.configuration.getConcurrencyLevel())) : (this.transactionManager == null ? new ReentrantPerEntryLockContainer(this.configuration.getConcurrencyLevel()) : new OwnableReentrantPerEntryLockContainer(this.configuration.getConcurrencyLevel()));
    }

    @Override
    public boolean lockAndRecord(Object key, InvocationContext ctx, long timeoutMillis) throws InterruptedException {
        if (trace) {
            log.tracef("Attempting to lock %s with acquisition timeout of %s millis", key, timeoutMillis);
        }
        if (this.lockContainer.acquireLock(ctx.getLockOwner(), key, timeoutMillis, TimeUnit.MILLISECONDS) != null) {
            if (trace) {
                log.tracef("Successfully acquired lock %s!", key);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Failed to acquire lock %s, owner is %s", key, this.getOwner(key));
            Object owner = ctx.getLockOwner();
            Set<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
            ArrayList<Object> lockedKeys = new ArrayList<Object>(entries.size());
            for (Map.Entry<Object, CacheEntry> e : entries) {
                Object lockedKey = e.getKey();
                if (!this.ownsLock(lockedKey, owner)) continue;
                lockedKeys.add(lockedKey);
            }
            log.debugf("This transaction (%s) already owned locks %s", owner, lockedKeys);
        }
        return false;
    }

    protected long getLockAcquisitionTimeout(InvocationContext ctx) {
        return ctx.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT) ? 0L : this.configuration.getLockAcquisitionTimeout();
    }

    @Override
    public void unlock(Collection<Object> lockedKeys, Object lockOwner) {
        log.tracef("Attempting to unlock keys %s", lockedKeys);
        for (Object k : lockedKeys) {
            this.lockContainer.releaseLock(lockOwner, k);
        }
    }

    @Override
    public void unlockAll(InvocationContext ctx) {
        for (Object k : ctx.getLockedKeys()) {
            if (trace) {
                log.tracef("Attempting to unlock %s", k);
            }
            this.lockContainer.releaseLock(ctx.getLockOwner(), k);
        }
        ctx.clearLockedKeys();
    }

    @Override
    public boolean ownsLock(Object key, Object owner) {
        return this.lockContainer.ownsLock(key, owner);
    }

    @Override
    public boolean isLocked(Object key) {
        return this.lockContainer.isLocked(key);
    }

    @Override
    public Object getOwner(Object key) {
        if (this.lockContainer.isLocked(key)) {
            Object l = this.lockContainer.getLock(key);
            if (l instanceof OwnableReentrantLock) {
                return ((OwnableReentrantLock)l).getOwner();
            }
            return ANOTHER_THREAD;
        }
        return null;
    }

    @Override
    public String printLockInfo() {
        return this.lockContainer.toString();
    }

    @Override
    public final boolean possiblyLocked(CacheEntry entry) {
        return entry == null || entry.isChanged() || entry.isNull() || entry.isLockPlaceholder();
    }

    @ManagedAttribute(description="The concurrency level that the MVCC Lock Manager has been configured with.")
    @Metric(displayName="Concurrency level", dataType=DataType.TRAIT)
    public int getConcurrencyLevel() {
        return this.configuration.getConcurrencyLevel();
    }

    @Override
    @ManagedAttribute(description="The number of exclusive locks that are held.")
    @Metric(displayName="Number of locks held")
    public int getNumberOfLocksHeld() {
        return this.lockContainer.getNumLocksHeld();
    }

    @ManagedAttribute(description="The number of exclusive locks that are available.")
    @Metric(displayName="Number of locks available")
    public int getNumberOfLocksAvailable() {
        return this.lockContainer.size() - this.lockContainer.getNumLocksHeld();
    }

    @Override
    public int getLockId(Object key) {
        return this.lockContainer.getLockId(key);
    }

    @Override
    public final boolean acquireLock(InvocationContext ctx, Object key) throws InterruptedException, TimeoutException {
        return this.acquireLock(ctx, key, -1L);
    }

    @Override
    public boolean acquireLock(InvocationContext ctx, Object key, long timeoutMillis) throws InterruptedException, TimeoutException {
        if (!ctx.hasLockedKey(key) && !ctx.hasFlag(Flag.SKIP_LOCKING)) {
            return this.lock(ctx, key, timeoutMillis < 0L ? this.getLockAcquisitionTimeout(ctx) : timeoutMillis);
        }
        this.logLockNotAcquired(ctx);
        return false;
    }

    @Override
    public final boolean acquireLockNoCheck(InvocationContext ctx, Object key) throws InterruptedException, TimeoutException {
        if (!ctx.hasFlag(Flag.SKIP_LOCKING)) {
            return this.lock(ctx, key, this.getLockAcquisitionTimeout(ctx));
        }
        this.logLockNotAcquired(ctx);
        return false;
    }

    private boolean lock(InvocationContext ctx, Object key, long timeoutMillis) throws InterruptedException {
        if (this.lockAndRecord(key, ctx, timeoutMillis)) {
            ctx.addLockedKey(key);
            return true;
        }
        Object owner = this.getOwner(key);
        if (key instanceof MarshalledValue) {
            key = ((MarshalledValue)key).get();
        }
        throw new TimeoutException("Unable to acquire lock after [" + Util.prettyPrintTime(this.getLockAcquisitionTimeout(ctx)) + "] on key [" + key + "] for requestor [" + ctx.getLockOwner() + "]! Lock held by [" + owner + "]");
    }

    private void logLockNotAcquired(InvocationContext ctx) {
        if (trace) {
            if (ctx.hasFlag(Flag.SKIP_LOCKING)) {
                log.trace("SKIP_LOCKING flag used!");
            } else {
                log.trace("Already own lock for entry");
            }
        }
    }
}

