/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.AutoInstallProvider;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.spi.util.StringPropertyReplacer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

final class DefaultAutoInstallProvider
extends AbstractPluginService<AutoInstallProvider>
implements AutoInstallProvider {
    static final Logger log = Logger.getLogger(DefaultAutoInstallProvider.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        DefaultAutoInstallProvider service = new DefaultAutoInstallProvider();
        ServiceBuilder builder = serviceTarget.addService(Services.AUTOINSTALL_PROVIDER, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(Services.FRAMEWORK_INIT);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private DefaultAutoInstallProvider() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        try {
            URL url;
            ArrayList<URL> autoInstall = new ArrayList<URL>();
            ArrayList<URL> autoStart = new ArrayList<URL>();
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            String propValue = (String)bundleManager.getProperty("org.jboss.osgi.auto.install");
            if (propValue != null) {
                for (String path : propValue.split(",")) {
                    url = this.toURL(bundleManager, path.trim());
                    if (url == null) continue;
                    autoInstall.add(url);
                }
            }
            if ((propValue = (String)bundleManager.getProperty("org.jboss.osgi.auto.start")) != null) {
                for (String path : propValue.split(",")) {
                    url = this.toURL(bundleManager, path.trim());
                    if (url == null) continue;
                    autoStart.add(url);
                }
            }
            ServiceTarget serviceTarget = context.getChildTarget();
            this.installBundles(serviceTarget, autoInstall, autoStart);
        }
        catch (BundleException ex) {
            throw new IllegalStateException("Cannot start auto install bundles", ex);
        }
    }

    public DefaultAutoInstallProvider getValue() {
        return this;
    }

    private void installBundles(ServiceTarget serviceTarget, List<URL> autoInstall, List<URL> autoStart) throws BundleException {
        autoInstall.addAll(autoStart);
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        final HashMap<ServiceName, Deployment> pendingServices = new HashMap<ServiceName, Deployment>();
        for (URL url : autoInstall) {
            BundleInfo info = BundleInfo.createBundleInfo((URL)url);
            Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
            dep.setAutoStart(autoStart.contains(url));
            ServiceName serviceName = bundleManager.installBundle(serviceTarget, dep);
            pendingServices.put(serviceName, dep);
        }
        ServiceName servicesInstalled = Services.AUTOINSTALL_PROVIDER.append(new String[]{"INSTALLED"});
        ServiceBuilder builder = serviceTarget.addService(servicesInstalled, (Service)new AbstractService<Void>(){

            public void start(StartContext context) throws StartException {
                log.debugf("Auto bundles installed", new Object[0]);
            }
        });
        builder.addDependencies(pendingServices.keySet());
        builder.install();
        builder = serviceTarget.addService(Services.AUTOINSTALL_PROVIDER_COMPLETE, (Service)new AbstractService<Void>(){

            public void start(StartContext context) throws StartException {
                for (Deployment dep : pendingServices.values()) {
                    if (!dep.isAutoStart()) continue;
                    Bundle bundle = (Bundle)dep.getAttachment(Bundle.class);
                    try {
                        bundle.start();
                    }
                    catch (BundleException ex) {
                        log.errorf((Throwable)ex, "Cannot start persistent bundle: %s", (Object)bundle);
                    }
                }
                log.debugf("Auto bundles started", new Object[0]);
            }
        });
        builder.addDependencies(new ServiceName[]{servicesInstalled});
        builder.install();
    }

    private URL toURL(final BundleManager bundleManager, String path) {
        URL pathURL = null;
        StringPropertyReplacer.PropertyProvider provider = new StringPropertyReplacer.PropertyProvider(){

            public String getProperty(String key) {
                return (String)bundleManager.getProperty(key);
            }
        };
        String realPath = StringPropertyReplacer.replaceProperties((String)path, (StringPropertyReplacer.PropertyProvider)provider);
        try {
            pathURL = new URL(realPath);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (pathURL == null) {
            try {
                File file = new File(realPath);
                if (file.exists()) {
                    pathURL = file.toURI().toURL();
                }
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Invalid path: " + realPath, ex);
            }
        }
        if (pathURL == null) {
            throw new IllegalArgumentException("Invalid path: " + realPath);
        }
        return pathURL;
    }
}

