/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleBuilder;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class DeploymentFactoryPlugin
extends AbstractPluginService<DeploymentFactoryPlugin> {
    private static final Logger log = Logger.getLogger(DeploymentFactoryPlugin.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<ResolverPlugin> injectedResolver = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        DeploymentFactoryPlugin service = new DeploymentFactoryPlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.DEPLOYMENT_FACTORY_PLUGIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(InternalServices.RESOLVER_PLUGIN, ResolverPlugin.class, service.injectedResolver);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    DeploymentFactoryPlugin() {
    }

    public DeploymentFactoryPlugin getValue() {
        return this;
    }

    Deployment createDeployment(BundleStorageState storageState) throws BundleException {
        if (storageState == null) {
            throw new IllegalArgumentException("Null storageState");
        }
        try {
            String location = storageState.getLocation();
            VirtualFile rootFile = storageState.getRootFile();
            Deployment dep = this.createDeployment(location, rootFile);
            dep.setAutoStart(storageState.isPersistentlyStarted());
            dep.addAttachment(BundleStorageState.class, (Object)storageState);
            return dep;
        }
        catch (BundleException ex) {
            storageState.deleteBundleStorage();
            throw ex;
        }
        catch (RuntimeException ex) {
            storageState.deleteBundleStorage();
            throw ex;
        }
    }

    Deployment createDeployment(Module module, OSGiMetaData metadata) throws BundleException {
        XModule resModule;
        Version version;
        String symbolicName;
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (metadata == null) {
            ModuleIdentifier identifier = module.getIdentifier();
            symbolicName = identifier.getName();
            try {
                version = Version.parseVersion((String)identifier.getSlot());
            }
            catch (IllegalArgumentException ex) {
                version = Version.emptyVersion;
            }
        } else {
            symbolicName = metadata.getBundleSymbolicName();
            version = metadata.getBundleVersion();
        }
        String location = module.getIdentifier().toString();
        Deployment dep = DeploymentFactory.createDeployment((String)location, (String)symbolicName, (Version)version);
        ResolverPlugin resolverPlugin = (ResolverPlugin)((Object)this.injectedResolver.getValue());
        XModuleBuilder builder = resolverPlugin.getModuleBuilder();
        if (metadata == null) {
            builder.createModule(symbolicName, version, 0);
            builder.addBundleCapability(symbolicName, version);
            for (String path : module.getExportedPaths()) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.isEmpty() || path.startsWith("META-INF")) continue;
                String packageName = path.replace('/', '.');
                builder.addPackageCapability(packageName, null, null);
            }
            resModule = builder.getModule();
        } else {
            builder.createModule(metadata, 0);
            resModule = builder.getModule();
            dep.addAttachment(OSGiMetaData.class, (Object)metadata);
        }
        resModule.addAttachment(Module.class, (Object)module);
        dep.addAttachment(XModule.class, (Object)resModule);
        dep.addAttachment(Module.class, (Object)module);
        return dep;
    }

    Deployment createDeployment(String location, VirtualFile rootFile) throws BundleException {
        BundleException cause = null;
        try {
            BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)rootFile, (String)location);
            Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
            OSGiMetaData metadata = this.toOSGiMetaData(info);
            dep.addAttachment(BundleInfo.class, (Object)info);
            dep.addAttachment(OSGiMetaData.class, (Object)metadata);
            return dep;
        }
        catch (NumberFormatException nfe) {
            throw new BundleException("Invalid number format: " + nfe.getMessage(), (Throwable)nfe);
        }
        catch (BundleException ex) {
            cause = ex;
            OSGiMetaData metadata = this.getXServiceMetaData(rootFile);
            if (metadata != null) {
                String symbolicName = metadata.getBundleSymbolicName();
                Version version = metadata.getBundleVersion();
                Deployment dep = DeploymentFactory.createDeployment((VirtualFile)rootFile, (String)location, (String)symbolicName, (Version)version);
                dep.addAttachment(OSGiMetaData.class, (Object)metadata);
                return dep;
            }
            Manifest manifest = null;
            try {
                manifest = VFSUtils.getManifest((VirtualFile)rootFile);
            }
            catch (IOException ex2) {
                // empty catch block
            }
            if (manifest != null && manifest.getMainAttributes().keySet().size() < 2) {
                Deployment dep = DeploymentFactory.createDeployment((VirtualFile)rootFile, (String)location, null, (Version)Version.emptyVersion);
                metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
                dep.addAttachment(OSGiMetaData.class, (Object)metadata);
                return dep;
            }
            if (cause != null) {
                throw cause;
            }
            throw new BundleException("Cannot create deployment from: " + rootFile);
        }
    }

    OSGiMetaData createOSGiMetaData(Deployment dep) throws BundleException {
        VirtualFile rootFile;
        OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
        if (metadata != null) {
            return metadata;
        }
        BundleInfo info = (BundleInfo)dep.getAttachment(BundleInfo.class);
        if (info != null) {
            metadata = this.toOSGiMetaData(info);
        }
        XModule resModule = (XModule)dep.getAttachment(XModule.class);
        if (metadata == null && resModule != null) {
            metadata = this.toOSGiMetaData(dep, resModule);
        }
        if (metadata == null) {
            rootFile = dep.getRoot();
            String location = dep.getLocation();
            try {
                info = BundleInfo.createBundleInfo((VirtualFile)rootFile, (String)location);
                metadata = this.toOSGiMetaData(info);
            }
            catch (BundleException ex) {
                // empty catch block
            }
        }
        if (metadata == null) {
            rootFile = dep.getRoot();
            metadata = this.getXServiceMetaData(rootFile);
        }
        if (metadata == null) {
            throw new BundleException("Not a valid OSGi deployment: " + dep);
        }
        dep.addAttachment(OSGiMetaData.class, (Object)metadata);
        return metadata;
    }

    private OSGiMetaData getXServiceMetaData(VirtualFile rootFile) {
        try {
            VirtualFile child = rootFile.getChild("META-INF/jbosgi-xservice.properties");
            if (child != null) {
                OSGiMetaData metadata = OSGiMetaDataBuilder.load((InputStream)child.openStream());
                return metadata;
            }
            VirtualFile parentFile = rootFile.getParent();
            if (parentFile != null && (child = parentFile.getChild("jbosgi-xservice.properties")) != null) {
                OSGiMetaData metadata = OSGiMetaDataBuilder.load((InputStream)child.openStream());
                return metadata;
            }
        }
        catch (IOException ex) {
            log.warnf((Throwable)ex, "Cannot process XService metadata: %s", (Object)rootFile);
        }
        return null;
    }

    private OSGiMetaData toOSGiMetaData(BundleInfo info) {
        Manifest manifest = info.getManifest();
        return OSGiMetaDataBuilder.load((Manifest)manifest);
    }

    private OSGiMetaData toOSGiMetaData(Deployment dep, XModule resModule) {
        String symbolicName = dep.getSymbolicName();
        Version version = Version.parseVersion((String)dep.getVersion());
        if (!symbolicName.equals(resModule.getName()) || !version.equals((Object)resModule.getVersion())) {
            throw new IllegalArgumentException("Inconsistent bundle metadata: " + resModule);
        }
        OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)symbolicName, (Version)version);
        return builder.getOSGiMetaData();
    }
}

