/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsr77.managedobject;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.jsr77.managedobject.BaseHandler;
import org.jboss.as.jsr77.managedobject.ModelReader;
import org.jboss.as.jsr77.managedobject.ObjectNameBuilder;
import org.jboss.as.jsr77.managedobject.SecurityActions;

class JVMHandler
extends BaseHandler {
    static final JVMHandler INSTANCE = new JVMHandler();
    private static final String ATTR_JVM_NAME = "javaVersion";
    private static final String ATTR_JAVA_VENDOR = "javaVendor";
    private static final String ATTR_NODE = "node";
    static final String J2EE_TYPE = "JVM";
    static final String DEFAULT_JVM_TYPE = "default";
    private final String objectName = ObjectNameBuilder.createServerChild("JVM", "default").toString();

    private JVMHandler() {
    }

    String getObjectName() {
        return this.objectName;
    }

    @Override
    Set<ObjectName> queryObjectNames(ModelReader reader, ObjectName name, QueryExp query) {
        return Collections.singleton(ObjectNameBuilder.createObjectName(this.getObjectName()));
    }

    @Override
    protected Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException {
        if (attribute.equals(ATTR_JVM_NAME)) {
            return SecurityActions.getSystemProperty("java.version");
        }
        if (attribute.equals(ATTR_JAVA_VENDOR)) {
            return SecurityActions.getSystemProperty("java.vendor");
        }
        if (attribute.equals(ATTR_NODE)) {
            try {
                return InetAddressUtil.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return super.getAttribute(reader, name, attribute);
    }

    @Override
    Set<MBeanAttributeInfo> getAttributeInfos() {
        Set<MBeanAttributeInfo> attributes = super.getAttributeInfos();
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_JVM_NAME, String[].class.getName(), "The jvm name"));
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_JAVA_VENDOR, String.class.getName(), "The java vendor"));
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_NODE, String.class.getName(), "The node"));
        return attributes;
    }
}

