/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.osgi.resolver.XAttachmentSupport;
import org.jboss.osgi.resolver.XAttributeSupport;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XDirectiveSupport;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.jboss.osgi.resolver.spi.AbstractModule;
import org.jboss.osgi.resolver.spi.AbstractResolver;

class AbstractCapability
extends AbstractElement
implements XCapability {
    private XModule module;
    private XDirectiveSupport directives;
    private XAttributeSupport attributes;
    private XAttachmentSupport attachments;

    public AbstractCapability(AbstractModule module, String name, Map<String, String> dirs, Map<String, Object> atts) {
        super(name);
        this.module = module;
        if (dirs != null) {
            this.directives = new AbstractElement.DirectiveSupporter(dirs);
        }
        if (atts != null) {
            this.attributes = new AbstractElement.AttributeSupporter(atts);
        }
    }

    public XModule getModule() {
        return this.module;
    }

    public Set<XRequirement> getWiredRequirements() {
        if (!this.getModule().isResolved()) {
            return null;
        }
        AbstractResolver resolver = (AbstractResolver)this.getModule().getResolver();
        if (resolver == null) {
            return Collections.emptySet();
        }
        return resolver.getWiredRequirements(this);
    }

    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(key);
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return this.attributes.getAttributes();
    }

    public String getDirective(String key) {
        if (this.directives == null) {
            return null;
        }
        return this.directives.getDirective(key);
    }

    public Map<String, String> getDirectives() {
        if (this.directives == null) {
            return Collections.emptyMap();
        }
        return this.directives.getDirectives();
    }

    public <T> T addAttachment(Class<T> clazz, T value) {
        if (this.attachments == null) {
            this.attachments = new AbstractElement.AttachmentSupporter();
        }
        return (T)this.attachments.addAttachment(clazz, value);
    }

    public <T> T getAttachment(Class<T> clazz) {
        if (this.attachments == null) {
            return null;
        }
        return (T)this.attachments.getAttachment(clazz);
    }

    public <T> T removeAttachment(Class<T> clazz) {
        if (this.attachments == null) {
            return null;
        }
        return (T)this.attachments.removeAttachment(clazz);
    }
}

