/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem.parsing;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.appclient.logging.AppClientMessages;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.CommonXml;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ExtensionXml;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class AppClientXml
extends CommonXml {
    private final ExtensionXml extensionXml;

    public AppClientXml(ModuleLoader loader, ExtensionRegistry extensionRegistry) {
        this.extensionXml = new ExtensionXml(loader, null, extensionRegistry);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operationList) throws XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        if (Element.forName((String)reader.getLocalName()) != Element.SERVER) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        Namespace readerNS = Namespace.forUri((String)reader.getNamespaceURI());
        switch (readerNS) {
            case DOMAIN_1_0: {
                this.readServerElement_1_0(reader, address, operationList);
                break;
            }
            case DOMAIN_1_1: {
                this.readServerElement_1_1(reader, address, operationList);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void readServerElement_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        String serverName = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            serverName = value;
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block11;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, Namespace.DOMAIN_1_0, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, Namespace.DOMAIN_1_0, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, Namespace.DOMAIN_1_0, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, Namespace.DOMAIN_1_0, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup(reader, interfaceNames, address, Namespace.DOMAIN_1_0, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readServerElement_1_1(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        String serverName = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            serverName = value;
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block11;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_1);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, Namespace.DOMAIN_1_1, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_1);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, Namespace.DOMAIN_1_1, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_1);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, Namespace.DOMAIN_1_1, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_1);
        }
        if (element == Element.VAULT) {
            this.parseVault(reader, address, Namespace.DOMAIN_1_1, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_1);
        }
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_1);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, Namespace.DOMAIN_1_1, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_1);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup(reader, interfaceNames, address, Namespace.DOMAIN_1_1, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_1);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSocketBindingGroup(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, Namespace expectedNs, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        ModelNode op = Util.getEmptyOperation((String)"add", null);
        String socketBindingGroupName = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.DEFAULT_INTERFACE);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    socketBindingGroupName = value;
                    required.remove(attribute);
                    continue block9;
                }
                case DEFAULT_INTERFACE: {
                    SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    required.remove(attribute);
                    continue block9;
                }
                case PORT_OFFSET: {
                    SocketBindingGroupResourceDefinition.PORT_OFFSET.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode groupAddress = address.clone().add("socket-binding-group", socketBindingGroupName);
        op.get("address").set(groupAddress);
        updates.add(op);
        block10: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerMessages.MESSAGES.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
                case OUTBOUND_SOCKET_BINDING: {
                    String bindingName = this.parseOutboundSocketBinding(reader, interfaces, socketBindingGroupName, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerMessages.MESSAGES.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerProfile(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> configuredSubsystemTypes = new HashSet<String>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!configuredSubsystemTypes.add(reader.getNamespaceURI())) {
                throw AppClientMessages.MESSAGES.duplicateSubsystemDeclaration(reader.getLocation());
            }
            ArrayList subsystems = new ArrayList();
            reader.handleAny(subsystems);
            for (ModelNode update : subsystems) {
                ModelNode subsystemAddress = address.clone();
                for (Property path : update.get("address").asPropertyList()) {
                    subsystemAddress.add(path.getName(), path.getValue().asString());
                }
                update.get("address").set(subsystemAddress);
                list.add(update);
            }
        }
    }

    private void setServerName(ModelNode address, List<ModelNode> operationList, String value) {
        if (value != null && value.length() > 0) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"name", (String)value);
            operationList.add(update);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
    }
}

