/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.mail.extension.Attribute;
import org.jboss.as.mail.extension.Credentials;
import org.jboss.as.mail.extension.Element;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.MailSessionServer;
import org.jboss.as.mail.extension.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class MailSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final Logger log = Logger.getLogger(MailSubsystemParser.class);

    MailSubsystemParser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        log.tracef("model node: %s", (Object)context.getModelNode());
        ModelNode model = context.getModelNode();
        List sessions = model.get("mail-session").asPropertyList();
        for (Property mailSession : sessions) {
            ModelNode server;
            String jndi = mailSession.getName();
            log.tracef("jndi: %s", (Object)jndi);
            ModelNode sessionData = mailSession.getValue();
            writer.writeStartElement(Element.MAIL_SESSION.getLocalName());
            writer.writeAttribute(Attribute.JNDI_NAME.getLocalName(), jndi);
            boolean debug = sessionData.get("debug").asBoolean(false);
            if (debug) {
                writer.writeAttribute(Attribute.DEBUG.getLocalName(), sessionData.get("debug").asString());
            }
            if (sessionData.hasDefined("from")) {
                writer.writeAttribute(Attribute.FROM.getLocalName(), sessionData.get("from").asString());
            }
            if ((server = sessionData.get("server")).hasDefined("smtp")) {
                this.writeServerModel(writer, server, "smtp", "smtp-server");
            }
            if (server.hasDefined("pop3")) {
                this.writeServerModel(writer, server, "pop3", "pop3-server");
            }
            if (server.hasDefined("imap")) {
                this.writeServerModel(writer, server, "imap", "imap-server");
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeServerModel(XMLExtendedStreamWriter writer, ModelNode sessionData, String name, String elementName) throws XMLStreamException {
        ModelNode server = sessionData.get(name);
        boolean credentials = server.hasDefined("username");
        if (credentials) {
            writer.writeStartElement(Element.forName(elementName).getLocalName());
        } else {
            writer.writeEmptyElement(Element.forName(elementName).getLocalName());
        }
        boolean sslDefined = server.get("ssl").asBoolean(false);
        if (sslDefined) {
            writer.writeAttribute(Attribute.SSL.getLocalName(), server.get("ssl").asString());
        }
        writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING_REF.getLocalName(), server.get("outbound-socket-binding-ref").asString());
        if (credentials) {
            writer.writeEmptyElement(Element.LOGIN.getLocalName());
            writer.writeAttribute(Attribute.USERNAME.getLocalName(), server.get("username").asString());
            writer.writeAttribute(Attribute.PASSWORD.getLocalName(), server.get("password").asString());
            writer.writeEndElement();
        }
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        LinkedList<MailSessionConfig> sessionConfigList = new LinkedList<MailSessionConfig>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MAIL_SESSION: {
                            sessionConfigList.add(this.parseMailSession(reader, list));
                            continue block6;
                        }
                    }
                    reader.handleAny(list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode address = new ModelNode();
        address.add("subsystem", "mail");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        for (MailSessionConfig c : sessionConfigList) {
            ModelNode dsAddress = address.clone();
            dsAddress.add("mail-session", c.getJndiName());
            dsAddress.protect();
            ModelNode operation = new ModelNode();
            operation.get("address").set(dsAddress);
            operation.get("operation").set("add");
            operation.get("jndi-name").set(c.getJndiName());
            operation.get("debug").set(c.isDebug());
            if (c.getFrom() != null) {
                operation.get("from").set(c.getFrom());
            }
            list.add(operation);
            MailSubsystemParser.fillSessionData(c, dsAddress, list);
        }
        log.tracef("parsing done, config is: %s", sessionConfigList);
        log.tracef("list is: %s", list);
    }

    static void fillSessionData(MailSessionConfig sessionConfig, ModelNode address, List<ModelNode> list) {
        if (sessionConfig.getSmtpServer() != null) {
            MailSubsystemParser.addServerConfig(sessionConfig.getSmtpServer(), "smtp", address, list);
        }
        if (sessionConfig.getPop3Server() != null) {
            MailSubsystemParser.addServerConfig(sessionConfig.getPop3Server(), "pop3", address, list);
        }
        if (sessionConfig.getImapServer() != null) {
            MailSubsystemParser.addServerConfig(sessionConfig.getImapServer(), "imap", address, list);
        }
    }

    private static void addServerConfig(MailSessionServer server, String name, ModelNode parent, List<ModelNode> list) {
        ModelNode address = parent.clone();
        address.add("server", name);
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("address").set(address);
        operation.get("operation").set("add");
        operation.get("outbound-socket-binding-ref").set(server.getOutgoingSocketBinding());
        operation.get("ssl").set(server.isSslEnabled());
        MailSubsystemParser.addCredentials(operation, server.getCredentials());
        list.add(operation);
    }

    private static void addCredentials(ModelNode operation, Credentials credentials) {
        if (credentials != null) {
            operation.get("username").set(credentials.getUsername());
            operation.get("password").set(credentials.getPassword());
        }
    }

    private MailSessionConfig parseMailSession(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        log.debug((Object)"parsing mail session");
        MailSessionConfig cfg = new MailSessionConfig();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attr = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            if (attr == Attribute.JNDI_NAME) {
                log.tracef("jndi name: %s", (Object)value);
                cfg.setJndiName(value);
            }
            if (attr == Attribute.DEBUG) {
                boolean debug = Boolean.parseBoolean(value.trim());
                cfg.setDebug(debug);
            }
            if (attr != Attribute.FROM) continue;
            cfg.setFrom(value);
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SMTP_SERVER: {
                            cfg.setSmtpServer(this.parseServerConfig(reader));
                            continue block9;
                        }
                        case POP3_SERVER: {
                            cfg.setPop3Server(this.parseServerConfig(reader));
                            continue block9;
                        }
                        case IMAP_SERVER: {
                            cfg.setImapServer(this.parseServerConfig(reader));
                            continue block9;
                        }
                    }
                    reader.handleAny(list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return cfg;
    }

    private MailSessionServer parseServerConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        String socketBindingRef = null;
        String username = null;
        String password = null;
        boolean ssl = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attr = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            if (attr == Attribute.OUTBOUND_SOCKET_BINDING_REF) {
                socketBindingRef = value;
            }
            if (attr != Attribute.SSL) continue;
            ssl = Boolean.parseBoolean(value.trim());
        }
        if (socketBindingRef == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.OUTBOUND_SOCKET_BINDING_REF.getLocalName()));
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN: {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String att = reader.getAttributeLocalName(i);
                        if (att.equals(Attribute.USERNAME.getLocalName())) {
                            username = reader.getAttributeValue(i);
                            continue;
                        }
                        if (!att.equals(Attribute.PASSWORD.getLocalName())) continue;
                        password = reader.getAttributeValue(i);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                }
            }
        }
        return new MailSessionServer(socketBindingRef, username, password, ssl);
    }
}

