/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorAdd;
import org.jboss.as.remoting.ConnectorRemove;
import org.jboss.as.remoting.NamedValueAttributeDefinition;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.SecurityActions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.xnio.Option;
import org.xnio.OptionMap;

public class ConnectorResource
extends SimpleResourceDefinition {
    static final ConnectorResource INSTANCE = new ConnectorResource();
    static final SimpleAttributeDefinition AUTHENTICATION_PROVIDER = new NamedValueAttributeDefinition("authentication-provider", Attribute.NAME, null, ModelType.STRING, true);
    static final SimpleAttributeDefinition SOCKET_BINDING = new SimpleAttributeDefinition("socket-binding", ModelType.STRING, false);

    private ConnectorResource() {
        super(PathElement.pathElement((String)"connector"), RemotingExtension.getResourceDescriptionResolver("connector"), (OperationStepHandler)ConnectorAdd.INSTANCE, (OperationStepHandler)ConnectorRemove.INSTANCE);
    }

    protected static OptionMap getOptions(ModelNode properties) {
        OptionMap optionMap;
        if (properties.isDefined() && properties.asInt() > 0) {
            OptionMap.Builder builder = OptionMap.builder();
            ClassLoader loader = SecurityActions.getClassLoader(ConnectorResource.class);
            for (Property property : properties.asPropertyList()) {
                String name = property.getName();
                if (!name.contains(".")) {
                    name = "org.xnio.Options." + name;
                }
                Option option = Option.fromString((String)name, (ClassLoader)loader);
                builder.set(option, option.parseValue(property.getValue().get("value").asString(), loader));
            }
            optionMap = builder.getMap();
        } else {
            optionMap = OptionMap.EMPTY;
        }
        return optionMap;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{AUTHENTICATION_PROVIDER, SOCKET_BINDING});
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTHENTICATION_PROVIDER, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SOCKET_BINDING, null, (OperationStepHandler)writeHandler);
    }
}

