/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.JAXRConstants;
import org.jboss.as.jaxr.extension.JAXRSubsystemParser;
import org.jboss.as.jaxr.extension.JAXRSubsystemRootResource;
import org.jboss.as.jaxr.extension.JAXRSubsystemWriter;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JAXRSubsystemExtension
implements Extension {
    private final JAXRSubsystemParser parser = new JAXRSubsystemParser();
    private final JAXRConfiguration config = new JAXRConfiguration();

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping("jaxr", JAXRConstants.Namespace.CURRENT.getUriString(), (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem("jaxr", 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new JAXRSubsystemRootResource(this.config));
        registration.registerOperationHandler("describe", (OperationStepHandler)SubsystemDescribeHandler.INSTANCE, (DescriptionProvider)SubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)JAXRSubsystemWriter.INSTANCE);
    }

    private static class SubsystemDescribeHandler
    extends GenericSubsystemDescribeHandler {
        static final SubsystemDescribeHandler INSTANCE = new SubsystemDescribeHandler();

        private SubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.execute(context, operation);
            context.completeStep();
        }
    }
}

