/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;

public class CacheContainerAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheContainerAdd.class.getPackage().getName());
    public static final CacheContainerAdd INSTANCE = new CacheContainerAdd();

    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        if (source.hasDefined("default-cache")) {
            target.get("default-cache").set(source.get("default-cache"));
        }
        if (source.hasDefined("aliases")) {
            target.get("aliases").set(source.get("aliases"));
        }
        if (source.hasDefined("jndi-name")) {
            target.get("jndi-name").set(source.get("jndi-name"));
        }
        if (source.hasDefined("start")) {
            target.get("start").set(source.get("start"));
        }
        if (source.hasDefined("listener-executor")) {
            target.get("listener-executor").set(source.get("listener-executor"));
        }
        if (source.hasDefined("eviction-executor")) {
            target.get("eviction-executor").set(source.get("eviction-executor"));
        }
        if (source.hasDefined("replication-queue-executor")) {
            target.get("replication-queue-executor").set(source.get("replication-queue-executor"));
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        CacheContainerAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String defaultCache = model.get("default-cache").asString();
        boolean hasTransport = model.hasDefined("transport") && model.get("transport").hasDefined("TRANSPORT");
        Transport transportConfig = hasTransport ? new Transport() : null;
        EmbeddedCacheManagerDependencies dependencies = new EmbeddedCacheManagerDependencies(transportConfig);
        ServiceName[] aliases = null;
        if (model.hasDefined("aliases")) {
            List list = operation.get("aliases").asList();
            aliases = new ServiceName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
            }
        }
        ServiceController.Mode initialMode = model.hasDefined("start") ? StartMode.valueOf(model.get("start").asString()).getMode() : ServiceController.Mode.ON_DEMAND;
        ServiceTarget target = context.getServiceTarget();
        ServiceName serviceName = EmbeddedCacheManagerService.getServiceName(name);
        ServiceBuilder containerBuilder = target.addService(serviceName, (Service)new EmbeddedCacheManagerService(name, defaultCache, dependencies)).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, dependencies.getMBeanServerInjector()).addAliases(aliases).setInitialMode(initialMode);
        String jndiName = (model.hasDefined("jndi-name") ? InfinispanJndiName.toJndiName(model.get("jndi-name").asString()) : InfinispanJndiName.defaultCacheContainerJndiName(name)).getAbsoluteName();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(serviceName, CacheContainer.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        newControllers.add(binderBuilder.install());
        if (hasTransport) {
            String stack = null;
            ModelNode transport = model.get(new String[]{"transport", "TRANSPORT"});
            if (transport.hasDefined("stack")) {
                stack = transport.get("stack").asString();
            }
            if (transport.hasDefined("lock-timeout")) {
                transportConfig.setLockTimeout(transport.get("lock-timeout").asLong());
            }
            this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManager>)containerBuilder, transport, "executor", transportConfig.getExecutorInjector());
            ServiceName channelServiceName = ChannelService.getServiceName((String)name);
            containerBuilder.addDependency(channelServiceName, Channel.class, transportConfig.getChannelInjector());
            InjectedValue channelFactory = new InjectedValue();
            ServiceBuilder channelBuilder = target.addService(channelServiceName, (Service)new ChannelService(name, (Value)channelFactory)).addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, (Injector)channelFactory).setInitialMode(ServiceController.Mode.ON_DEMAND);
            newControllers.add(channelBuilder.install());
        }
        this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManager>)containerBuilder, model, "listener-executor", dependencies.getListenerExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManager>)containerBuilder, model, "eviction-executor", dependencies.getEvictionExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManager>)containerBuilder, model, "replication-queue-executor", dependencies.getReplicationQueueExecutorInjector());
        newControllers.add(containerBuilder.install());
        log.debugf("%s cache container installed", (Object)name);
    }

    private void addExecutorDependency(ServiceBuilder<EmbeddedCacheManager> builder, ModelNode model, String key, Injector<Executor> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), Executor.class, injector);
        }
    }

    private void addScheduledExecutorDependency(ServiceBuilder<EmbeddedCacheManager> builder, ModelNode model, String key, Injector<ScheduledExecutorService> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), ScheduledExecutorService.class, injector);
        }
    }

    static class Transport
    implements EmbeddedCacheManagerService.TransportConfiguration {
        private final InjectedValue<Channel> channel = new InjectedValue();
        private final InjectedValue<Executor> executor = new InjectedValue();
        private Long lockTimeout;

        Transport() {
        }

        void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }

        Injector<Channel> getChannelInjector() {
            return this.channel;
        }

        Injector<Executor> getExecutorInjector() {
            return this.executor;
        }

        @Override
        public Channel getChannel() {
            return (Channel)this.channel.getValue();
        }

        @Override
        public Executor getExecutor() {
            return (Executor)this.executor.getOptionalValue();
        }

        @Override
        public Long getLockTimeout() {
            return this.lockTimeout;
        }
    }

    static class EmbeddedCacheManagerDependencies
    implements EmbeddedCacheManagerService.Dependencies {
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> evictionExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
        private final EmbeddedCacheManagerService.TransportConfiguration transport;

        EmbeddedCacheManagerDependencies(EmbeddedCacheManagerService.TransportConfiguration transport) {
            this.transport = transport;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<Executor> getListenerExecutorInjector() {
            return this.listenerExecutor;
        }

        Injector<ScheduledExecutorService> getEvictionExecutorInjector() {
            return this.evictionExecutor;
        }

        Injector<ScheduledExecutorService> getReplicationQueueExecutorInjector() {
            return this.replicationQueueExecutor;
        }

        @Override
        public EmbeddedCacheManagerService.TransportConfiguration getTransportConfiguration() {
            return this.transport;
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public Executor getListenerExecutor() {
            return (Executor)this.listenerExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getEvictionExecutor() {
            return (ScheduledExecutorService)this.evictionExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getReplicationQueueExecutor() {
            return (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        }
    }
}

