/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.jboss.as.clustering.infinispan.ChannelProvider;
import org.jboss.as.clustering.infinispan.DefaultEmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.ExecutorProvider;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jgroups.Channel;
import org.jgroups.util.TopologyUUID;

@Listener
public class EmbeddedCacheManagerService
extends AsynchronousService<EmbeddedCacheManager> {
    private static final Logger log = Logger.getLogger((String)EmbeddedCacheManagerService.class.getPackage().getName());
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"infinispan"});
    private final String name;
    private final String defaultCache;
    private final Dependencies dependencies;
    private volatile EmbeddedCacheManager container;

    public static ServiceName getServiceName(String name) {
        return name != null ? SERVICE_NAME.append(new String[]{name}) : SERVICE_NAME;
    }

    public EmbeddedCacheManagerService(String name, String defaultCache, Dependencies dependencies) {
        this.name = name;
        this.defaultCache = defaultCache;
        this.dependencies = dependencies;
    }

    public EmbeddedCacheManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this.container;
    }

    protected void start() {
        ScheduledExecutorService replicationQueueExecutor;
        ScheduledExecutorService evictionExecutor;
        Executor listenerExecutor;
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
        globalBuilder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        TransportConfiguration transport = this.dependencies.getTransportConfiguration();
        TransportConfigurationBuilder transportBuilder = globalBuilder.transport();
        if (transport != null) {
            Channel channel;
            ChannelProvider.init(transportBuilder, transport.getChannel());
            Long timeout = transport.getLockTimeout();
            if (timeout != null) {
                transportBuilder.distributedSyncTimeout(timeout.longValue());
            }
            if ((channel = transport.getChannel()).getAddress() instanceof TopologyUUID) {
                String machine;
                String rack;
                TopologyUUID topologyAddress = (TopologyUUID)channel.getAddress();
                String site = topologyAddress.getSiteId();
                if (site != null) {
                    transportBuilder.siteId(site);
                }
                if ((rack = topologyAddress.getRackId()) != null) {
                    transportBuilder.rackId(rack);
                }
                if ((machine = topologyAddress.getMachineId()) != null) {
                    transportBuilder.machineId(machine);
                }
            }
            transportBuilder.clusterName(this.name);
            Executor executor = transport.getExecutor();
            if (executor != null) {
                ExecutorProvider.initTransportExecutor(globalBuilder, executor);
            }
        }
        if ((listenerExecutor = this.dependencies.getListenerExecutor()) != null) {
            ExecutorProvider.initListenerExecutor(globalBuilder, listenerExecutor);
        }
        if ((evictionExecutor = this.dependencies.getEvictionExecutor()) != null) {
            ExecutorProvider.initEvictionExecutor(globalBuilder, evictionExecutor);
        }
        if ((replicationQueueExecutor = this.dependencies.getReplicationQueueExecutor()) != null) {
            ExecutorProvider.initReplicationQueueExecutor(globalBuilder, replicationQueueExecutor);
        }
        GlobalJmxStatisticsConfigurationBuilder jmxBuilder = globalBuilder.globalJmxStatistics().cacheManagerName(this.name);
        MBeanServer server = this.dependencies.getMBeanServer();
        if (server != null) {
            jmxBuilder.enable().mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider(server)).jmxDomain(SERVICE_NAME.getCanonicalName()).allowDuplicateDomains(Boolean.valueOf(true));
        } else {
            jmxBuilder.disable();
        }
        this.container = new DefaultEmbeddedCacheManager(globalBuilder.build(), this.defaultCache);
        this.container.addListener((Object)this);
        this.container.start();
        log.debugf("%s cache container started", (Object)this.name);
    }

    protected void stop() {
        if (this.container != null && this.container.getStatus().allowInvocations()) {
            this.container.stop();
            this.container.removeListener((Object)this);
            log.debugf("%s cache container stopped", (Object)this.name);
        }
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStarted(event.getCacheName(), new DefaultEmbeddedCacheManager(event.getCacheManager(), null).getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName());
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStopped(event.getCacheName(), new DefaultEmbeddedCacheManager(event.getCacheManager(), null).getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName());
    }

    static interface Dependencies {
        public TransportConfiguration getTransportConfiguration();

        public MBeanServer getMBeanServer();

        public Executor getListenerExecutor();

        public ScheduledExecutorService getEvictionExecutor();

        public ScheduledExecutorService getReplicationQueueExecutor();
    }

    static interface TransportConfiguration {
        public Long getLockTimeout();

        public Channel getChannel();

        public Executor getExecutor();
    }
}

