/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.FormatterSpec;
import org.jboss.as.logging.util.LogServices;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public abstract class HandlerUpdateProperties<T extends Handler>
implements OperationStepHandler {
    public static final String OPERATION_NAME = "update-properties";
    private final Set<String> attributes;
    private final List<AttributeDefinition> attributeDefinitions;

    protected HandlerUpdateProperties(AttributeDefinition ... attributeDefinitions) {
        this.attributes = Collections.emptySet();
        this.attributes.addAll(this.attributes);
        this.attributeDefinitions = new ArrayList<AttributeDefinition>();
        this.attributeDefinitions.add((AttributeDefinition)CommonAttributes.ENCODING);
        this.attributeDefinitions.add((AttributeDefinition)CommonAttributes.FORMATTER);
        this.attributeDefinitions.add((AttributeDefinition)CommonAttributes.LEVEL);
        this.attributeDefinitions.add((AttributeDefinition)CommonAttributes.FILTER);
        Collections.addAll(this.attributeDefinitions, attributeDefinitions);
    }

    protected HandlerUpdateProperties(String ... attributes) {
        this.attributes = new HashSet<String>();
        Collections.addAll(this.attributes, attributes);
        this.attributeDefinitions = Collections.emptyList();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        final ModelNode originalModel = resource.getModel().clone();
        final ModelNode model = resource.getModel();
        this.updateModel(operation, model);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String name = address.getLastElement().getValue();
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
                    ServiceController controller = serviceRegistry.getService(LogServices.handlerName(name));
                    if (controller != null) {
                        Handler handler = (Handler)controller.getValue();
                        ModelNode level = CommonAttributes.LEVEL.resolveModelAttribute(context, model);
                        ModelNode formatter = CommonAttributes.FORMATTER.resolveModelAttribute(context, model);
                        ModelNode encoding = CommonAttributes.ENCODING.resolveModelAttribute(context, model);
                        ModelNode filter = CommonAttributes.FILTER.resolveModelAttribute(context, model);
                        if (level.isDefined()) {
                            handler.setLevel(ModelParser.parseLevel(level));
                        }
                        if (formatter.isDefined()) {
                            FormatterSpec.fromModelNode(context, model).apply(handler);
                        }
                        if (encoding.isDefined()) {
                            try {
                                handler.setEncoding(encoding.asString());
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new OperationFailedException((Throwable)e, new ModelNode().set(LoggingMessages.MESSAGES.failedToSetHandlerEncoding()));
                            }
                        }
                        if (filter.isDefined()) {
                            handler.setFilter(ModelParser.parseFilter(context, filter));
                        }
                        boolean restartRequired = HandlerUpdateProperties.this.applyUpdateToRuntime(context, name, model, originalModel, handler);
                        HandlerUpdateProperties.this.copyOriginal(originalModel, model);
                        if (restartRequired) {
                            context.reloadRequired();
                        }
                        if (context.completeStep() != OperationContext.ResultAction.KEEP) {
                            try {
                                HandlerUpdateProperties.this.revertUpdateToRuntime(context, name, model, originalModel, handler);
                            }
                            catch (Exception e) {
                                LoggingLogger.ROOT_LOGGER.errorRevertingOperation(e, this.getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.require("address")));
                            }
                            if (restartRequired) {
                                context.revertReloadRequired();
                            }
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected final void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : this.attributeDefinitions) {
            attributeDefinition.validateAndSet(operation, model);
        }
        for (String string : this.attributes) {
            this.copy(string, operation, model);
        }
    }

    protected abstract boolean applyUpdateToRuntime(OperationContext var1, String var2, ModelNode var3, ModelNode var4, T var5) throws OperationFailedException;

    protected abstract void revertUpdateToRuntime(OperationContext var1, String var2, ModelNode var3, ModelNode var4, T var5) throws OperationFailedException;

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER && !context.isBooting();
    }

    protected void copy(String name, ModelNode from, ModelNode to) {
        if (from.hasDefined(name)) {
            to.get(name).set(from.get(name));
        }
    }

    private void copyOriginal(ModelNode originalModel, ModelNode model) {
        for (String key : originalModel.keys()) {
            if (!originalModel.hasDefined(key) || model.hasDefined(key)) continue;
            model.get(key).set(originalModel.get(key));
        }
    }

    public final Collection<AttributeDefinition> getAttributes() {
        return Collections.unmodifiableCollection(this.attributeDefinitions);
    }
}

