/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.jboss.as.clustering.MarshalledValue;
import org.jboss.as.clustering.MarshallingContext;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.Unmarshaller;

public class SimpleMarshalledValue<T>
implements MarshalledValue<T, MarshallingContext> {
    private static final long serialVersionUID = -8852566958387608376L;
    private volatile transient MarshallingContext context;
    private volatile transient T object;
    private volatile transient byte[] bytes;

    public SimpleMarshalledValue(T object, MarshallingContext context) {
        this.context = context;
        this.object = object;
    }

    T peek() {
        return this.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes() throws IOException {
        byte[] bytes = this.bytes;
        if (bytes != null) {
            return bytes;
        }
        if (this.object == null) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Marshaller marshaller = this.context.createMarshaller();
        try {
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            ClassLoader currentLoader = null;
            ClassLoader contextLoader = this.context.getContextClassLoader();
            if (contextLoader != null) {
                currentLoader = SimpleMarshalledValue.getCurrentThreadContextClassLoader();
                SimpleMarshalledValue.setCurrentThreadContextClassLoader(contextLoader);
            }
            try {
                marshaller.writeObject(this.object);
            }
            finally {
                if (contextLoader != null) {
                    SimpleMarshalledValue.setCurrentThreadContextClassLoader(currentLoader);
                }
            }
            marshaller.finish();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            marshaller.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T get(MarshallingContext context) throws IOException, ClassNotFoundException {
        if (this.object == null) {
            this.context = context;
            if (this.bytes != null) {
                Unmarshaller unmarshaller = context.createUnmarshaller();
                try {
                    unmarshaller.start(Marshalling.createByteInput((InputStream)new ByteArrayInputStream(this.bytes)));
                    ClassLoader currentLoader = null;
                    ClassLoader contextLoader = context.getContextClassLoader();
                    if (contextLoader != null) {
                        currentLoader = SimpleMarshalledValue.getCurrentThreadContextClassLoader();
                        SimpleMarshalledValue.setCurrentThreadContextClassLoader(contextLoader);
                    }
                    try {
                        this.object = unmarshaller.readObject();
                    }
                    finally {
                        if (contextLoader != null) {
                            SimpleMarshalledValue.setCurrentThreadContextClassLoader(currentLoader);
                        }
                    }
                    unmarshaller.finish();
                    this.bytes = null;
                }
                finally {
                    unmarshaller.close();
                }
            }
        }
        return this.object;
    }

    public int hashCode() {
        return this.object != null ? this.object.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SimpleMarshalledValue)) {
            return false;
        }
        SimpleMarshalledValue value = (SimpleMarshalledValue)object;
        if (this.object != null && value.object != null) {
            return this.object.equals(value.object);
        }
        try {
            byte[] us = this.getBytes();
            byte[] them = value.getBytes();
            return us != null && them != null ? Arrays.equals(us, them) : us == them;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        if (this.object != null) {
            return this.object.toString();
        }
        byte[] bytes = this.bytes;
        return bytes != null ? bytes.toString() : null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        byte[] bytes = null;
        if (size > 0) {
            bytes = new byte[size];
            in.read(bytes);
        }
        this.bytes = bytes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        byte[] bytes = this.getBytes();
        if (bytes != null) {
            out.writeInt(bytes.length);
            out.write(bytes);
        } else {
            out.writeInt(0);
        }
    }

    static ClassLoader getCurrentThreadContextClassLoader() {
        PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        return AccessController.doPrivileged(action);
    }

    static void setCurrentThreadContextClassLoader(final ClassLoader loader) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }
}

