/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.web.Attribute;
import org.jboss.as.web.DefaultJspConfig;
import org.jboss.as.web.DefaultStaticResources;
import org.jboss.as.web.Element;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class WebSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final WebSubsystemParser INSTANCE = new WebSubsystemParser();

    WebSubsystemParser() {
    }

    static WebSubsystemParser getInstance() {
        return INSTANCE;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode config;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        WebSubsystemParser.writeAttribute(writer, Attribute.NATIVE.getLocalName(), node);
        WebSubsystemParser.writeAttribute(writer, Attribute.DEFAULT_VIRTUAL_SERVER.getLocalName(), node);
        WebSubsystemParser.writeAttribute(writer, Attribute.INSTANCE_ID.getLocalName(), node);
        if (node.hasDefined("configuration")) {
            this.writeContainerConfig(writer, node.get("configuration"));
        }
        if (node.hasDefined("connector")) {
            for (Property connector : node.get("connector").asPropertyList()) {
                config = connector.getValue();
                writer.writeStartElement(Element.CONNECTOR.getLocalName());
                writer.writeAttribute("name", connector.getName());
                WebSubsystemParser.writeAttribute(writer, Attribute.PROTOCOL.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.SCHEME.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.SOCKET_BINDING.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.ENABLE_LOOKUPS.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.PROXY_NAME.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.PROXY_PORT.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.REDIRECT_PORT.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.SECURE.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.MAX_POST_SIZE.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.MAX_SAVE_POST_SIZE.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.ENABLED.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.EXECUTOR.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.MAX_CONNECTIONS.getLocalName(), config);
                if (config.get("ssl").isDefined() && config.get("ssl").has("configuration")) {
                    ModelNode sslConfig = config.get("ssl").get("configuration");
                    writer.writeStartElement(Element.SSL.getLocalName());
                    WebSubsystemParser.writeAttribute(writer, Attribute.NAME.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.KEY_ALIAS.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.PASSWORD.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CERTIFICATE_KEY_FILE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CIPHER_SUITE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.PROTOCOL.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.VERIFY_CLIENT.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.VERIFY_DEPTH.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CERTIFICATE_FILE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CA_CERTIFICATE_FILE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CA_REVOCATION_URL.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CA_CERTIFICATE_PASSWORD.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.KEYSTORE_TYPE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.TRUSTSTORE_TYPE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.SESSION_CACHE_SIZE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.SESSION_TIMEOUT.getLocalName(), sslConfig);
                    writer.writeEndElement();
                }
                if (config.hasDefined("virtual-server")) {
                    for (ModelNode virtualServer : config.get("virtual-server").asList()) {
                        writer.writeEmptyElement("virtual-server");
                        writer.writeAttribute("name", virtualServer.asString());
                    }
                }
                writer.writeEndElement();
            }
        }
        if (node.hasDefined("virtual-server")) {
            for (Property host : node.get("virtual-server").asPropertyList()) {
                String name;
                config = host.getValue();
                writer.writeStartElement(Element.VIRTUAL_SERVER.getLocalName());
                writer.writeAttribute("name", host.getName());
                WebSubsystemParser.writeAttribute(writer, Attribute.DEFAULT_WEB_MODULE.getLocalName(), config);
                if (config.hasDefined("enable-welcome-root")) {
                    writer.writeAttribute("enable-welcome-root", String.valueOf(config.get("enable-welcome-root").asBoolean()));
                }
                if (config.hasDefined("alias")) {
                    for (ModelNode alias : config.get("alias").asList()) {
                        writer.writeEmptyElement("alias");
                        writer.writeAttribute("name", alias.asString());
                    }
                }
                if (config.get("access-log").isDefined() && config.get("access-log").has("configuration")) {
                    ModelNode accessLog = config.get("access-log").get("configuration");
                    writer.writeStartElement(Element.ACCESS_LOG.getLocalName());
                    WebSubsystemParser.writeAttribute(writer, Attribute.PATTERN.getLocalName(), accessLog);
                    WebSubsystemParser.writeAttribute(writer, Attribute.RESOLVE_HOSTS.getLocalName(), accessLog);
                    WebSubsystemParser.writeAttribute(writer, Attribute.EXTENDED.getLocalName(), accessLog);
                    WebSubsystemParser.writeAttribute(writer, Attribute.PREFIX.getLocalName(), accessLog);
                    WebSubsystemParser.writeAttribute(writer, Attribute.ROTATE.getLocalName(), accessLog);
                    if (accessLog.has("directory") && accessLog.get("directory").has("configuration")) {
                        ModelNode directory = accessLog.get("directory").get("configuration");
                        name = Element.DIRECTORY.getLocalName();
                        boolean startwritten = false;
                        startwritten = this.writeAttribute(writer, Attribute.PATH.getLocalName(), directory, startwritten, name);
                        startwritten = this.writeAttribute(writer, Attribute.RELATIVE_TO.getLocalName(), directory, startwritten, name);
                        if (startwritten) {
                            writer.writeEndElement();
                        }
                    }
                    writer.writeEndElement();
                }
                if (config.hasDefined("rewrite")) {
                    for (ModelNode rewritenode : config.get("rewrite").asList()) {
                        ModelNode rewrite = rewritenode.hasDefined(name = this.getAddedRule(rewritenode)) ? rewritenode.get(name) : rewritenode;
                        writer.writeStartElement("rewrite");
                        WebSubsystemParser.writeAttribute(writer, Attribute.PATTERN.getLocalName(), rewrite);
                        WebSubsystemParser.writeAttribute(writer, Attribute.SUBSTITUTION.getLocalName(), rewrite);
                        WebSubsystemParser.writeAttribute(writer, Attribute.FLAGS.getLocalName(), rewrite);
                        if (rewrite.hasDefined("condition")) {
                            for (ModelNode conditionnode : rewrite.get("condition").asList()) {
                                String condname;
                                ModelNode condition = conditionnode.hasDefined(condname = this.getAddedConditionName(conditionnode)) ? conditionnode.get(condname) : conditionnode;
                                writer.writeStartElement("condition");
                                WebSubsystemParser.writeAttribute(writer, Attribute.TEST.getLocalName(), condition);
                                WebSubsystemParser.writeAttribute(writer, Attribute.PATTERN.getLocalName(), condition);
                                WebSubsystemParser.writeAttribute(writer, Attribute.FLAGS.getLocalName(), condition);
                                writer.writeEndElement();
                            }
                        }
                        writer.writeEndElement();
                    }
                }
                if (config.hasDefined("sso") && config.get("sso").has("configuration")) {
                    ModelNode sso = config.get("sso").get("configuration");
                    writer.writeStartElement("sso");
                    WebSubsystemParser.writeAttribute(writer, Attribute.CACHE_CONTAINER.getLocalName(), sso);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CACHE_NAME.getLocalName(), sso);
                    WebSubsystemParser.writeAttribute(writer, Attribute.DOMAIN.getLocalName(), sso);
                    WebSubsystemParser.writeAttribute(writer, Attribute.REAUTHENTICATE.getLocalName(), sso);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private String getAddedConditionName(ModelNode conditionnode) {
        for (String attribute : conditionnode.keys()) {
            if (!attribute.startsWith("condition-")) continue;
            return attribute;
        }
        return "condition-0";
    }

    private String getAddedRule(ModelNode rewritenode) {
        for (String attribute : rewritenode.keys()) {
            if (!attribute.startsWith("rule-")) continue;
            return attribute;
        }
        return "rule-0";
    }

    private void writeContainerConfig(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        boolean containerConfigStartWritten = false;
        if (config.hasDefined("static-resources")) {
            containerConfigStartWritten = this.writeStaticResources(writer, config.get("static-resources"));
        }
        if (config.hasDefined("jsp-configuration")) {
            containerConfigStartWritten = this.writeJSPConfiguration(writer, config.get("jsp-configuration"), containerConfigStartWritten) || containerConfigStartWritten;
        }
        ModelNode container = config;
        if (config.hasDefined("container")) {
            container = config.get("container");
        }
        if (container.hasDefined("mime-mapping")) {
            if (!containerConfigStartWritten) {
                writer.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
                containerConfigStartWritten = true;
            }
            for (Property entry : container.get("mime-mapping").asPropertyList()) {
                writer.writeEmptyElement(Element.MIME_MAPPING.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), entry.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), entry.getValue().asString());
            }
        }
        if (container.hasDefined("welcome-file")) {
            if (!containerConfigStartWritten) {
                writer.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
                containerConfigStartWritten = true;
            }
            for (ModelNode file : container.get("welcome-file").asList()) {
                writer.writeStartElement(Element.WELCOME_FILE.getLocalName());
                writer.writeCharacters(file.asString());
                writer.writeEndElement();
            }
        }
        if (containerConfigStartWritten) {
            writer.writeEndElement();
        }
    }

    private boolean writeStaticResources(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        boolean startWritten = this.writeStaticResourceAttribute(writer, Attribute.LISTINGS.getLocalName(), config, false);
        startWritten = this.writeStaticResourceAttribute(writer, Attribute.SENDFILE.getLocalName(), config, startWritten) || startWritten;
        startWritten = this.writeStaticResourceAttribute(writer, Attribute.FILE_ENCONDING.getLocalName(), config, startWritten) || startWritten;
        startWritten = this.writeStaticResourceAttribute(writer, Attribute.READ_ONLY.getLocalName(), config, startWritten) || startWritten;
        startWritten = this.writeStaticResourceAttribute(writer, Attribute.WEBDAV.getLocalName(), config, startWritten) || startWritten;
        startWritten = this.writeStaticResourceAttribute(writer, Attribute.SECRET.getLocalName(), config, startWritten) || startWritten;
        startWritten = this.writeStaticResourceAttribute(writer, Attribute.MAX_DEPTH.getLocalName(), config, startWritten) || startWritten;
        boolean bl = startWritten = this.writeStaticResourceAttribute(writer, Attribute.DISABLED.getLocalName(), config, startWritten) || startWritten;
        if (startWritten) {
            writer.writeEndElement();
        }
        return startWritten;
    }

    private boolean writeStaticResourceAttribute(XMLExtendedStreamWriter writer, String attribute, ModelNode config, boolean startWritten) throws XMLStreamException {
        if (DefaultStaticResources.hasNotDefault(config, attribute)) {
            if (!startWritten) {
                writer.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
                writer.writeStartElement(Element.STATIC_RESOURCES.getLocalName());
            }
            writer.writeAttribute(attribute, config.get(attribute).asString());
            return true;
        }
        return false;
    }

    private boolean writeJSPConfiguration(XMLExtendedStreamWriter writer, ModelNode jsp, boolean containerConfigStartWritten) throws XMLStreamException {
        boolean startWritten = this.writeJspConfigAttribute(writer, Attribute.DEVELOPMENT.getLocalName(), jsp, false, containerConfigStartWritten);
        startWritten = this.writeJspConfigAttribute(writer, Attribute.DISABLED.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.KEEP_GENERATED.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.TRIM_SPACES.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.TAG_POOLING.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.MAPPED_FILE.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.CHECK_INTERVAL.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.MODIFIFICATION_TEST_INTERVAL.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.RECOMPILE_ON_FAIL.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.SMAP.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.DUMP_SMAP.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.GENERATE_STRINGS_AS_CHAR_ARRAYS.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.SCRATCH_DIR.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.SOURCE_VM.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.TARGET_VM.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.JAVA_ENCODING.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        startWritten = this.writeJspConfigAttribute(writer, Attribute.X_POWERED_BY.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        boolean bl = startWritten = this.writeJspConfigAttribute(writer, Attribute.DISPLAY_SOURCE_FRAGMENT.getLocalName(), jsp, startWritten, containerConfigStartWritten) || startWritten;
        if (startWritten) {
            writer.writeEndElement();
        }
        return startWritten;
    }

    private boolean writeJspConfigAttribute(XMLExtendedStreamWriter writer, String attribute, ModelNode config, boolean startWritten, boolean containerConfigStartWritten) throws XMLStreamException {
        if (DefaultJspConfig.hasNotDefault(config, attribute)) {
            if (!startWritten) {
                if (!containerConfigStartWritten) {
                    writer.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
                }
                writer.writeStartElement(Element.JSP_CONFIGURATION.getLocalName());
            }
            writer.writeAttribute(attribute, config.get(attribute).asString());
            return true;
        }
        return false;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "web");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NATIVE: 
                case DEFAULT_VIRTUAL_SERVER: 
                case INSTANCE_ID: {
                    subsystem.get(attribute.getLocalName()).set(value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(subsystem);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: 
                case WEB_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONTAINER_CONFIG: {
                            ModelNode config = WebSubsystemParser.parseContainerConfig(reader);
                            subsystem.get("configuration").set(config);
                            continue block12;
                        }
                        case CONNECTOR: {
                            WebSubsystemParser.parseConnector(reader, address, list);
                            continue block12;
                        }
                        case VIRTUAL_SERVER: {
                            WebSubsystemParser.parseHost(reader, address, list);
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode parseContainerConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode config = new ModelNode();
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATIC_RESOURCES: {
                    ModelNode resourceServing = WebSubsystemParser.parseStaticResources(reader);
                    config.get("static-resources").set(resourceServing);
                    continue block6;
                }
                case JSP_CONFIGURATION: {
                    ModelNode jspConfiguration = WebSubsystemParser.parseJSPConfiguration(reader);
                    config.get("jsp-configuration").set(jspConfiguration);
                    continue block6;
                }
                case MIME_MAPPING: {
                    String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
                    config.get("mime-mapping").get(array[0]).set(array[1]);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block6;
                }
                case WELCOME_FILE: {
                    String welcomeFile = reader.getElementText().trim();
                    config.get("welcome-file").add(welcomeFile);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return config;
    }

    static ModelNode parseJSPConfiguration(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode jsp = new ModelNode();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEVELOPMENT: 
                case DISABLED: 
                case KEEP_GENERATED: 
                case TRIM_SPACES: 
                case TAG_POOLING: 
                case MAPPED_FILE: 
                case CHECK_INTERVAL: 
                case MODIFIFICATION_TEST_INTERVAL: 
                case RECOMPILE_ON_FAIL: 
                case SMAP: 
                case DUMP_SMAP: 
                case GENERATE_STRINGS_AS_CHAR_ARRAYS: 
                case ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE: 
                case SCRATCH_DIR: 
                case SOURCE_VM: 
                case TARGET_VM: 
                case JAVA_ENCODING: 
                case X_POWERED_BY: 
                case DISPLAY_SOURCE_FRAGMENT: {
                    jsp.get(attribute.getLocalName()).set(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return jsp;
    }

    static ModelNode parseStaticResources(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode resources = new ModelNode();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LISTINGS: {
                    resources.get("listings").set(value);
                    continue block10;
                }
                case SENDFILE: {
                    resources.get("sendfile").set(value);
                    continue block10;
                }
                case FILE_ENCONDING: {
                    resources.get("file-encoding").set(value);
                    continue block10;
                }
                case READ_ONLY: {
                    resources.get("read-only").set(value);
                    continue block10;
                }
                case WEBDAV: {
                    resources.get("webdav").set(value);
                    continue block10;
                }
                case SECRET: {
                    resources.get("secret").set(value);
                    continue block10;
                }
                case MAX_DEPTH: {
                    resources.get("max-depth").set(value);
                    continue block10;
                }
                case DISABLED: {
                    resources.get("disabled").set(value);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return resources;
    }

    static void parseHost(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String defaultWebModule = null;
        boolean welcome = false;
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block20;
                }
                case DEFAULT_WEB_MODULE: {
                    if (welcome) {
                        throw new XMLStreamException(WebMessages.MESSAGES.noRootWebappWithWelcomeWebapp(), reader.getLocation());
                    }
                    defaultWebModule = value;
                    continue block20;
                }
                case ENABLE_WELCOME_ROOT: {
                    welcome = Boolean.parseBoolean(value);
                    if (!welcome || defaultWebModule == null) continue block20;
                    throw new XMLStreamException(WebMessages.MESSAGES.noWelcomeWebappWithDefaultWebModule(), reader.getLocation());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode host = new ModelNode();
        host.get("operation").set("add");
        host.get("address").set(address).add("virtual-server", name);
        if (defaultWebModule != null) {
            host.get("default-web-module").set(defaultWebModule);
        }
        host.get("enable-welcome-root").set(welcome);
        list.add(host);
        block21: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    ModelNode rewrite;
                    ModelNode log;
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ALIAS: {
                            host.get("alias").add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName()));
                            continue block21;
                        }
                        case ACCESS_LOG: {
                            log = WebSubsystemParser.parseHostAccessLog(reader);
                            host.get("access-log").set(log);
                            continue block21;
                        }
                        case REWRITE: {
                            rewrite = WebSubsystemParser.parseHostRewrite(reader);
                            host.get("rewrite").add(rewrite);
                            continue block21;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case WEB_1_1: {
                    ModelNode rewrite;
                    ModelNode log;
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ALIAS: {
                            host.get("alias").add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName()));
                            continue block21;
                        }
                        case ACCESS_LOG: {
                            log = WebSubsystemParser.parseHostAccessLog(reader);
                            host.get("access-log").set(log);
                            continue block21;
                        }
                        case REWRITE: {
                            rewrite = WebSubsystemParser.parseHostRewrite(reader);
                            host.get("rewrite").add(rewrite);
                            continue block21;
                        }
                        case SSO: {
                            ModelNode sso = WebSubsystemParser.parseSso(reader);
                            host.get("sso").set(sso);
                            continue block21;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode parseSso(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode sso = new ModelNode();
        sso.setEmptyObject();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE_CONTAINER: 
                case CACHE_NAME: 
                case DOMAIN: 
                case REAUTHENTICATE: {
                    sso.get(attribute.getLocalName()).set(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return sso;
    }

    static ModelNode parseHostRewrite(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode rewrite = new ModelNode();
        rewrite.setEmptyObject();
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATTERN: {
                    rewrite.get("pattern").set(value);
                    continue block16;
                }
                case SUBSTITUTION: {
                    rewrite.get("substitution").set(value);
                    continue block16;
                }
                case FLAGS: {
                    rewrite.get("flags").set(value);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: 
                case WEB_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONDITION: {
                            ModelNode condition = new ModelNode();
                            condition.setEmptyObject();
                            int count2 = reader.getAttributeCount();
                            block18: for (int i = 0; i < count2; ++i) {
                                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                                String value = reader.getAttributeValue(i);
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case TEST: {
                                        condition.get("test").set(value);
                                        continue block18;
                                    }
                                    case PATTERN: {
                                        condition.get("pattern").set(value);
                                        continue block18;
                                    }
                                    case FLAGS: {
                                        condition.get("flags").set(value);
                                        continue block18;
                                    }
                                    default: {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                }
                            }
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            rewrite.get("condition").add(condition);
                            continue block17;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return rewrite;
    }

    static ModelNode parseHostAccessLog(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode log = new ModelNode();
        log.setEmptyObject();
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATTERN: {
                    log.get("pattern").set(value);
                    continue block17;
                }
                case RESOLVE_HOSTS: {
                    log.get("resolve-hosts").set(value);
                    continue block17;
                }
                case EXTENDED: {
                    log.get("extended").set(value);
                    continue block17;
                }
                case PREFIX: {
                    log.get("prefix").set(value);
                    continue block17;
                }
                case ROTATE: {
                    log.get("rotate").set(value);
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block18: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: 
                case WEB_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case DIRECTORY: {
                            ModelNode directory = new ModelNode();
                            int count2 = reader.getAttributeCount();
                            block19: for (int i = 0; i < count2; ++i) {
                                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                                String value = reader.getAttributeValue(i);
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case PATH: {
                                        directory.get("path").set(value);
                                        continue block19;
                                    }
                                    case RELATIVE_TO: {
                                        directory.get("relative-to").set(value);
                                        continue block19;
                                    }
                                    default: {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                }
                            }
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            log.get("directory").set(directory);
                            continue block18;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return log;
    }

    static void parseConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String protocol = null;
        String bindingRef = null;
        String scheme = null;
        String executorRef = null;
        String enabled = null;
        String enableLookups = null;
        String proxyName = null;
        String proxyPort = null;
        String maxPostSize = null;
        String maxSavePostSize = null;
        String secure = null;
        String redirectPort = null;
        String maxConnections = null;
        int count = reader.getAttributeCount();
        block23: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block23;
                }
                case SOCKET_BINDING: {
                    bindingRef = value;
                    continue block23;
                }
                case SCHEME: {
                    scheme = value;
                    continue block23;
                }
                case PROTOCOL: {
                    protocol = value;
                    continue block23;
                }
                case EXECUTOR: {
                    executorRef = value;
                    continue block23;
                }
                case ENABLED: {
                    enabled = value;
                    continue block23;
                }
                case ENABLE_LOOKUPS: {
                    enableLookups = value;
                    continue block23;
                }
                case PROXY_NAME: {
                    proxyName = value;
                    continue block23;
                }
                case PROXY_PORT: {
                    proxyPort = value;
                    continue block23;
                }
                case MAX_POST_SIZE: {
                    maxPostSize = value;
                    continue block23;
                }
                case MAX_SAVE_POST_SIZE: {
                    maxSavePostSize = value;
                    continue block23;
                }
                case SECURE: {
                    secure = value;
                    continue block23;
                }
                case REDIRECT_PORT: {
                    redirectPort = value;
                    continue block23;
                }
                case MAX_CONNECTIONS: {
                    maxConnections = value;
                    continue block23;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (bindingRef == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
        }
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add");
        connector.get("address").set(address).add("connector", name);
        block24: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: 
                case WEB_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SSL: {
                            ModelNode ssl = WebSubsystemParser.parseSsl(reader);
                            connector.get("ssl").set(ssl);
                            continue block24;
                        }
                        case VIRTUAL_SERVER: {
                            connector.get("virtual-server").add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName()));
                            continue block24;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (protocol != null) {
            connector.get("protocol").set(protocol);
        }
        connector.get("socket-binding").set(bindingRef);
        if (scheme != null) {
            connector.get("scheme").set(scheme);
        }
        if (executorRef != null) {
            connector.get("executor").set(executorRef);
        }
        if (enabled != null) {
            connector.get("enabled").set(enabled);
        }
        if (enableLookups != null) {
            connector.get("enable-lookups").set(enableLookups);
        }
        if (proxyName != null) {
            connector.get("proxy-name").set(proxyName);
        }
        if (proxyPort != null) {
            connector.get("proxy-port").set(proxyPort);
        }
        if (maxPostSize != null) {
            connector.get("max-post-size").set(maxPostSize);
        }
        if (maxSavePostSize != null) {
            connector.get("max-save-post-size").set(maxSavePostSize);
        }
        if (secure != null) {
            connector.get("secure").set(secure);
        }
        if (redirectPort != null) {
            connector.get("redirect-port").set(redirectPort);
        }
        if (maxConnections != null) {
            connector.get("max-connections").set(maxConnections);
        }
        list.add(connector);
    }

    static ModelNode parseSsl(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.setEmptyObject();
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    ssl.get("name").set(value);
                    continue block18;
                }
                case KEY_ALIAS: {
                    ssl.get("key-alias").set(value);
                    continue block18;
                }
                case PASSWORD: {
                    ssl.get("password").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block18;
                }
                case CERTIFICATE_KEY_FILE: {
                    ssl.get("certificate-key-file").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block18;
                }
                case CIPHER_SUITE: {
                    ssl.get("cipher-suite").set(value);
                    continue block18;
                }
                case PROTOCOL: {
                    ssl.get("protocol").set(value);
                    continue block18;
                }
                case VERIFY_CLIENT: {
                    ssl.get("verify-client").set(value);
                    continue block18;
                }
                case VERIFY_DEPTH: {
                    ssl.get("verify-depth").set(Integer.valueOf(value).intValue());
                    continue block18;
                }
                case CERTIFICATE_FILE: {
                    ssl.get("certificate-file").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block18;
                }
                case CA_CERTIFICATE_FILE: {
                    ssl.get("ca-certificate-file").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block18;
                }
                case CA_REVOCATION_URL: {
                    ssl.get("ca-revocation-url").set(value);
                    continue block18;
                }
                case SESSION_CACHE_SIZE: {
                    ssl.get("session-cache-size").set(value);
                    continue block18;
                }
                case SESSION_TIMEOUT: {
                    ssl.get("session-timeout").set(value);
                    continue block18;
                }
                case CA_CERTIFICATE_PASSWORD: {
                    ssl.get("ca-certificate-password").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block18;
                }
                case KEYSTORE_TYPE: {
                    ssl.get("keystore-type").set(value);
                    continue block18;
                }
                case TRUSTSTORE_TYPE: {
                    ssl.get("truststore-type").set(value);
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return ssl;
    }

    static void writeAttribute(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(name)) {
            writer.writeAttribute(name, node.get(name).asString());
        }
    }

    private boolean writeAttribute(XMLExtendedStreamWriter writer, String name, ModelNode node, boolean startwritten, String origin) throws XMLStreamException {
        if (node.hasDefined(name)) {
            if (!startwritten) {
                startwritten = true;
                writer.writeStartElement(origin);
            }
            writer.writeAttribute(name, node.get(name).asString());
        }
        return startwritten;
    }
}

