/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.MessageInputStream;

class InvocationExceptionResponseHandler
extends ProtocolMessageHandler {
    private static final Logger logger = Logger.getLogger(InvocationExceptionResponseHandler.class);
    private final MarshallerFactory marshallerFactory;
    private final ChannelAssociation channelAssociation;

    InvocationExceptionResponseHandler(ChannelAssociation channelAssociation, MarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
        this.channelAssociation = channelAssociation;
    }

    @Override
    protected void processMessage(MessageInputStream messageInputStream) throws IOException {
        if (messageInputStream == null) {
            throw new IllegalArgumentException("Cannot read from null stream");
        }
        DataInputStream input = new DataInputStream(messageInputStream);
        short invocationId = input.readShort();
        MethodInvocationExceptionResultProducer resultProducer = new MethodInvocationExceptionResultProducer(input);
        this.channelAssociation.resultReady(invocationId, resultProducer);
    }

    private class MethodInvocationExceptionResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final DataInputStream input;

        MethodInvocationExceptionResultProducer(DataInputStream input) {
            this.input = input;
        }

        @Override
        public Object getResult() throws Exception {
            try {
                Unmarshaller unmarshaller = InvocationExceptionResponseHandler.this.prepareForUnMarshalling(InvocationExceptionResponseHandler.this.marshallerFactory, this.input);
                Object result = unmarshaller.readObject();
                Map<String, Object> attachments = InvocationExceptionResponseHandler.this.readAttachments(unmarshaller);
                unmarshaller.finish();
                if (!(result instanceof Throwable)) {
                    throw new RuntimeException("Method invocation failure message contained a payload: " + result + " which is *not* of type " + Throwable.class.getName());
                }
                Throwable t = (Throwable)result;
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
            catch (Throwable throwable) {
                this.input.close();
                throw throwable;
            }
        }

        @Override
        public void discardResult() {
        }
    }
}

