/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.remoting.AutoConnectionCloser;
import org.jboss.ejb.client.remoting.ClusterContextConnectionReconnectHandler;
import org.jboss.ejb.client.remoting.ClusterNode;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class RemotingConnectionClusterNodeManager
implements ClusterNodeManager {
    private static final Logger logger = Logger.getLogger(RemotingConnectionClusterNodeManager.class);
    private final ClusterContext clusterContext;
    private final ClusterNode clusterNode;
    private final Endpoint endpoint;
    private final EJBClientConfiguration ejbClientConfiguration;

    RemotingConnectionClusterNodeManager(ClusterContext clusterContext, ClusterNode clusterNode, Endpoint endpoint, EJBClientConfiguration ejbClientConfiguration) {
        this.clusterContext = clusterContext;
        this.clusterNode = clusterNode;
        this.endpoint = endpoint;
        this.ejbClientConfiguration = ejbClientConfiguration;
    }

    @Override
    public String getNodeName() {
        return this.clusterNode.getNodeName();
    }

    @Override
    public EJBReceiver getEJBReceiver() {
        ClusterContextConnectionReconnectHandler reconnectHandler;
        if (!this.clusterNode.isDestinationResolved()) {
            logger.error("Cannot create a EJB receiver for " + this.clusterNode + " since there was no match for a target destination");
            return null;
        }
        Connection connection = null;
        OptionMap channelCreationOptions = OptionMap.EMPTY;
        int MAX_RECONNECT_ATTEMPTS = 65535;
        try {
            if (this.ejbClientConfiguration != null) {
                URI connectionURI = new URI("remote://" + this.clusterNode.getDestinationAddress() + ":" + this.clusterNode.getDestinationPort());
                EJBClientConfiguration.ClusterConfiguration clusterConfiguration = this.ejbClientConfiguration.getClusterConfiguration(this.clusterContext.getClusterName());
                if (clusterConfiguration == null) {
                    OptionMap connectionCreationOptions = OptionMap.EMPTY;
                    CallbackHandler callbackHandler = this.ejbClientConfiguration.getCallbackHandler();
                    IoFuture<Connection> futureConnection = this.endpoint.connect(connectionURI, connectionCreationOptions, callbackHandler);
                    connection = IoFutureHelper.get(futureConnection, 5000L, TimeUnit.MILLISECONDS);
                    reconnectHandler = new ClusterContextConnectionReconnectHandler(this.clusterContext, this.endpoint, connectionURI, connectionCreationOptions, callbackHandler, channelCreationOptions, 65535);
                } else {
                    EJBClientConfiguration.ClusterNodeConfiguration clusterNodeConfiguration = clusterConfiguration.getNodeConfiguration(this.getNodeName());
                    channelCreationOptions = clusterNodeConfiguration == null ? clusterConfiguration.getChannelCreationOptions() : clusterNodeConfiguration.getChannelCreationOptions();
                    OptionMap connectionCreationOptions = clusterNodeConfiguration == null ? clusterConfiguration.getConnectionCreationOptions() : clusterNodeConfiguration.getConnectionCreationOptions();
                    CallbackHandler callbackHandler = clusterNodeConfiguration == null ? clusterConfiguration.getCallbackHandler() : clusterNodeConfiguration.getCallbackHandler();
                    IoFuture<Connection> futureConnection = this.endpoint.connect(connectionURI, connectionCreationOptions, callbackHandler);
                    long timeout = clusterNodeConfiguration == null ? clusterConfiguration.getConnectionTimeout() : clusterNodeConfiguration.getConnectionTimeout();
                    connection = IoFutureHelper.get(futureConnection, timeout, TimeUnit.MILLISECONDS);
                    reconnectHandler = new ClusterContextConnectionReconnectHandler(this.clusterContext, this.endpoint, connectionURI, connectionCreationOptions, callbackHandler, channelCreationOptions, 65535);
                }
            } else {
                URI connectionURI = new URI("remote://" + this.clusterNode.getDestinationAddress() + ":" + this.clusterNode.getDestinationPort());
                OptionMap connectionCreationOptions = OptionMap.EMPTY;
                AnonymousCallbackHandler callbackHandler = new AnonymousCallbackHandler();
                IoFuture<Connection> futureConnection = this.endpoint.connect(connectionURI, connectionCreationOptions, callbackHandler);
                connection = IoFutureHelper.get(futureConnection, 5000L, TimeUnit.MILLISECONDS);
                reconnectHandler = new ClusterContextConnectionReconnectHandler(this.clusterContext, this.endpoint, connectionURI, connectionCreationOptions, callbackHandler, channelCreationOptions, 65535);
            }
            if (connection != null) {
                AutoConnectionCloser.INSTANCE.addConnection(connection);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Could not create a connection for cluster node " + this.clusterNode + " in cluster " + this.clusterContext.getClusterName());
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    AutoConnectionCloser.INSTANCE.addConnection(connection);
                }
                throw throwable;
            }
        }
        return new RemotingConnectionEJBReceiver(connection, reconnectHandler, channelCreationOptions);
    }

    private class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }
}

