/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.weld.WeldContainer;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.context.ejb.EjbLiteral;
import org.jboss.weld.context.ejb.EjbRequestContext;
import org.jboss.weld.manager.BeanManagerImpl;

public class EjbRequestScopeActivationInterceptor
implements Serializable,
Interceptor {
    private volatile EjbRequestContext requestContext;
    private final ClassLoader classLoader;
    private final ServiceName weldContainerServiceName;
    private final boolean alwaysActivate;
    private static final Set<InvocationType> INVOCATION_TYPES;

    public EjbRequestScopeActivationInterceptor(ClassLoader classLoader, ServiceName weldContainerServiceName, boolean alwaysActivate) {
        this.classLoader = classLoader;
        this.weldContainerServiceName = weldContainerServiceName;
        this.alwaysActivate = alwaysActivate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        InvocationType marker = (InvocationType)context.getPrivateData(InvocationType.class);
        if (!(this.alwaysActivate || marker != null && INVOCATION_TYPES.contains(marker))) {
            return context.proceed();
        }
        if (this.requestContext == null) {
            WeldContainer weldContainer = (WeldContainer)CurrentServiceContainer.getServiceContainer().getRequiredService(this.weldContainerServiceName).getValue();
            BeanManagerImpl beanManager = (BeanManagerImpl)weldContainer.getBeanManager();
            Bean bean = beanManager.resolve(beanManager.getBeans(EjbRequestContext.class, new Annotation[]{EjbLiteral.INSTANCE}));
            WeldCreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
            this.requestContext = (EjbRequestContext)beanManager.getReference(bean, EjbRequestContext.class, (CreationalContext)ctx);
        }
        try {
            this.requestContext.associate((Object)context.getInvocationContext());
            this.requestContext.activate();
            Object object = context.proceed();
            return object;
        }
        finally {
            this.requestContext.deactivate();
            this.requestContext.dissociate((Object)context.getInvocationContext());
        }
    }

    static {
        HashSet<InvocationType> set = new HashSet<InvocationType>();
        set.add(InvocationType.ASYNC);
        set.add(InvocationType.REMOTE);
        set.add(InvocationType.TIMER);
        INVOCATION_TYPES = Collections.unmodifiableSet(set);
    }

    public static class Factory
    implements InterceptorFactory {
        private final Interceptor interceptor;
        private final boolean alwaysActivate;

        public Factory(ClassLoader classLoader, ServiceName weldContainerServiceName, boolean alwaysActivate) {
            this.alwaysActivate = alwaysActivate;
            this.interceptor = new EjbRequestScopeActivationInterceptor(classLoader, weldContainerServiceName, alwaysActivate);
        }

        public Interceptor create(InterceptorFactoryContext context) {
            return this.interceptor;
        }
    }
}

