/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.mysql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.jca.adapters.jdbc.spi.ValidConnectionChecker;
import org.jboss.logging.Logger;

public class MySQLValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static transient Logger log;
    private static final long serialVersionUID = 1323747853035005642L;
    private boolean driverHasPingMethod;
    private transient Method ping;

    public MySQLValidConnectionChecker() {
        try {
            this.initPing();
        }
        catch (Exception e) {
            log.warn((Object)"Cannot resolve com.mysq.jdbc.Connection.ping method.  Will use 'SELECT 1' instead.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLException isValidConnection(Connection c) {
        if (this.driverHasPingMethod) {
            try {
                this.ping.invoke((Object)c, (Object[])null);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    return (SQLException)e;
                }
                log.warn((Object)"Unexpected error in ping", (Throwable)e);
                return new SQLException("ping failed: " + e.toString());
            }
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.createStatement();
            rs = stmt.executeQuery("SELECT 1");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                SQLException sQLException = (SQLException)e;
                return sQLException;
            }
            log.warn((Object)"Unexpected error in ping (SELECT 1)", (Throwable)e);
            SQLException sQLException = new SQLException("ping (SELECT 1) failed: " + e.toString());
            return sQLException;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignore) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ignore) {}
        }
        return null;
    }

    private void initPing() throws ClassNotFoundException, NoSuchMethodException {
        log = Logger.getLogger(MySQLValidConnectionChecker.class);
        this.driverHasPingMethod = false;
        Class<?> mysqlConnection = Class.forName("com.mysql.jdbc.Connection", true, this.getClass().getClassLoader());
        this.ping = mysqlConnection.getMethod("ping", null);
        if (this.ping != null) {
            this.driverHasPingMethod = true;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            this.initPing();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to resolve ping method: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }
}

