/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.osgi.resolver.v2.NotImplementedException;
import org.jboss.osgi.resolver.v2.XEnvironment;
import org.jboss.osgi.resolver.v2.spi.AbstractElement;
import org.jboss.osgi.resolver.v2.spi.AbstractWiring;
import org.jboss.osgi.resolver.v2.spi.ResourceIndexComparator;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Requirement;
import org.osgi.framework.resource.Resource;
import org.osgi.framework.resource.Wire;
import org.osgi.framework.resource.Wiring;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

public class AbstractEnvironment
extends AbstractElement
implements XEnvironment {
    private final List<Resource> resources = new ArrayList<Resource>();
    private final Map<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();

    @Override
    public Comparator<Capability> getComparator() {
        return new ResourceIndexComparator(){

            @Override
            protected long getResourceIndex(Resource res) {
                return AbstractEnvironment.this.resources.indexOf(res);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installResources(Resource ... resarr) {
        if (this.resources == null) {
            throw new IllegalArgumentException("Null resource");
        }
        List<Resource> list = this.resources;
        synchronized (list) {
            for (Resource res : resarr) {
                if (this.resources.contains(res)) {
                    throw new IllegalArgumentException("Resource already installed: " + res);
                }
                this.resources.add(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallResources(Resource ... resarr) {
        List<Resource> list = this.resources;
        synchronized (list) {
            for (Resource res : resarr) {
                this.resources.remove(res);
            }
        }
    }

    public long getResourceIndex(Resource resource) {
        return this.resources.indexOf(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<Capability> findProviders(Requirement req) {
        TreeSet<Capability> result = new TreeSet<Capability>(this.getComparator());
        List<Resource> list = this.resources;
        synchronized (list) {
            for (Resource res : this.resources) {
                for (Capability cap : res.getCapabilities(req.getNamespace())) {
                    if (!(req instanceof BundleRequirement) || !((BundleRequirement)req).matches((BundleCapability)cap)) continue;
                    result.add(cap);
                }
            }
        }
        return result;
    }

    @Override
    public Map<Requirement, SortedSet<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Resource, Wiring> applyResolverResults(Map<Resource, List<Wire>> wiremap) {
        HashMap<Resource, Wiring> result = new HashMap<Resource, Wiring>();
        Map<Resource, Wiring> map = this.wirings;
        synchronized (map) {
            Resource res;
            for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
                res = entry.getKey();
                List<Wire> wires = entry.getValue();
                AbstractWiring reqwiring = (AbstractWiring)this.getWiring(result, res);
                reqwiring.addRequiredWires(wires);
                for (Wire wire : wires) {
                    Resource provider = wire.getProvider();
                    AbstractWiring provwiring = (AbstractWiring)this.getWiring(result, provider);
                    provwiring.addProvidedWire(wire);
                }
            }
            for (Map.Entry<Resource, List<Wire>> entry : result.entrySet()) {
                res = entry.getKey();
                Wiring delta = (Wiring)((Object)entry.getValue());
                AbstractWiring wiring = (AbstractWiring)this.wirings.get(res);
                if (wiring == null) {
                    this.wirings.put(res, delta);
                    continue;
                }
                for (Wire wire : delta.getProvidedResourceWires(null)) {
                    wiring.addProvidedWire(wire);
                }
            }
        }
        return result;
    }

    private Wiring getWiring(Map<Resource, Wiring> result, Resource requirer) {
        Wiring wiring = result.get(requirer);
        if (wiring == null) {
            wiring = new AbstractWiring(requirer);
            result.put(requirer, wiring);
        }
        return wiring;
    }

    @Override
    public boolean isEffective(Requirement req) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wiring getWiring(Resource resource) {
        Map<Resource, Wiring> map = this.wirings;
        synchronized (map) {
            return this.wirings.get(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Resource, Wiring> getWirings() {
        Map<Resource, Wiring> map = this.wirings;
        synchronized (map) {
            return Collections.unmodifiableMap(this.wirings);
        }
    }
}

