/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.v2.VersionRange;
import org.jboss.osgi.resolver.v2.XCapability;
import org.jboss.osgi.resolver.v2.XIdentityCapability;
import org.jboss.osgi.resolver.v2.XPackageCapability;
import org.jboss.osgi.resolver.v2.XPackageRequirement;
import org.jboss.osgi.resolver.v2.XResource;
import org.jboss.osgi.resolver.v2.spi.AbstractBundleRequirement;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

public class AbstractPackageRequirement
extends AbstractBundleRequirement
implements XPackageRequirement {
    private final String packageName;
    private final VersionRange versionrange;

    protected AbstractPackageRequirement(BundleRevision brev, Map<String, Object> attributes, Map<String, String> directives) {
        super(brev, "osgi.wiring.package", attributes, directives);
        this.packageName = (String)attributes.get("osgi.wiring.package");
        Object versionatt = attributes.get("version");
        if (versionatt instanceof String) {
            versionatt = VersionRange.parse((String)versionatt);
        }
        this.versionrange = (VersionRange)versionatt;
    }

    @Override
    protected List<String> getMandatoryAttributes() {
        return Arrays.asList("osgi.wiring.package");
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionrange;
    }

    @Override
    public boolean matches(BundleCapability cap) {
        Object capval;
        String dirstr;
        String versionstr;
        Version version;
        if (!super.matches(cap)) {
            return false;
        }
        if (this.versionrange != null && !this.versionrange.isInRange(version = ((XPackageCapability)((Object)cap)).getVersion())) {
            return false;
        }
        HashMap<String, Object> reqatts = new HashMap<String, Object>(this.getAttributes());
        HashMap<String, Object> capatts = new HashMap<String, Object>(cap.getAttributes());
        reqatts.remove("osgi.wiring.package");
        capatts.remove("osgi.wiring.package");
        reqatts.remove("version");
        capatts.remove("version");
        String symbolicName = (String)reqatts.remove("bundle-symbolic-name");
        if (symbolicName != null) {
            String targetSymbolicName;
            XResource capres = (XResource)((Object)cap.getResource());
            XIdentityCapability idcap = capres.getIdentityCapability();
            String string = targetSymbolicName = idcap != null ? idcap.getSymbolicName() : null;
            if (!symbolicName.equals(targetSymbolicName)) {
                return false;
            }
        }
        if ((versionstr = (String)reqatts.remove("bundle-version")) != null) {
            XResource capres = (XResource)((Object)cap.getResource());
            XIdentityCapability idcap = capres.getIdentityCapability();
            Version targetVersion = idcap != null ? idcap.getVersion() : null;
            VersionRange versionRange = VersionRange.parse(versionstr);
            if (targetVersion != null && !versionRange.isInRange(targetVersion)) {
                return false;
            }
        }
        if ((dirstr = ((XCapability)((Object)cap)).getDirective("mandatory")) != null) {
            for (String att : dirstr.split(",")) {
                Object reqval;
                capval = capatts.remove(att);
                if (capval.equals(reqval = reqatts.remove(att))) continue;
                return false;
            }
        }
        for (Map.Entry entry : reqatts.entrySet()) {
            String att = (String)entry.getKey();
            Object reqval = entry.getValue();
            if (reqval.equals(capval = capatts.remove(att))) continue;
            return false;
        }
        return true;
    }
}

