/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.jaxrpc.WSSecurityHandlerInbound;
import org.jboss.ws.extensions.security.jaxrpc.WSSecurityHandlerOutbound;
import org.jboss.ws.extensions.security.jaxws.WSSecurityHandlerClient;
import org.jboss.ws.extensions.security.jaxws.WSSecurityHandlerServer;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.InitalizableMetaData;
import org.jboss.ws.metadata.umdm.SecurityActions;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;

public abstract class HandlerMetaData
implements InitalizableMetaData,
Serializable {
    private static final ResourceBundle bundle = BundleUtils.getBundle(HandlerMetaData.class);
    private final Logger log = Logger.getLogger(HandlerMetaData.class);
    private transient EndpointMetaData epMetaData;
    private String handlerName;
    private String handlerClassName;
    private UnifiedHandlerMetaData.HandlerType handlerType;
    private Set<QName> soapHeaders = new HashSet<QName>();
    private List<UnifiedInitParamMetaData> initParams = new ArrayList<UnifiedInitParamMetaData>();
    private Class handlerClass;

    public HandlerMetaData(UnifiedHandlerMetaData.HandlerType type) {
        this.handlerType = type;
    }

    public void setEndpointMetaData(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public EndpointMetaData getEndpointMetaData() {
        return this.epMetaData;
    }

    public void setHandlerName(String value) {
        this.handlerName = value;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void setHandlerClassName(String handlerClass) {
        this.handlerClassName = handlerClass;
    }

    public String getHandlerClassName() {
        return this.handlerClassName;
    }

    public Class getHandlerClass() {
        if (this.handlerClassName == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"HANDLER_CLASS_NAME_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        Class<?> localClass = this.handlerClass;
        if (localClass == null) {
            try {
                ClassLoader loader = this.getClassLoader();
                localClass = loader.loadClass(this.handlerClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_LOAD_HANDLER", (Object[])new Object[]{this.handlerClassName}), ex);
            }
        }
        return localClass;
    }

    private ClassLoader getClassLoader() {
        ClassLoader ctxLoader = SecurityActions.getContextClassLoader();
        return this.epMetaData != null ? this.epMetaData.getClassLoader() : ctxLoader;
    }

    public UnifiedHandlerMetaData.HandlerType getHandlerType() {
        return this.handlerType;
    }

    public void setSoapHeaders(Set<QName> soapHeaders) {
        this.soapHeaders = soapHeaders;
    }

    public Set<QName> getSoapHeaders() {
        return this.soapHeaders;
    }

    public void setInitParams(List<UnifiedInitParamMetaData> initParams) {
        this.initParams = initParams;
    }

    public List<UnifiedInitParamMetaData> getInitParams() {
        return this.initParams;
    }

    public void validate() {
        ArrayList<String> securityHandlers = new ArrayList<String>();
        securityHandlers.add(WSSecurityHandlerInbound.class.getName());
        securityHandlers.add(WSSecurityHandlerOutbound.class.getName());
        securityHandlers.add(WSSecurityHandlerServer.class.getName());
        securityHandlers.add(WSSecurityHandlerClient.class.getName());
        if (securityHandlers.contains(this.handlerClassName) && this.epMetaData != null && this.epMetaData.getServiceMetaData().getSecurityConfiguration() == null) {
            this.log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"REQUIRES_SECURITY_CONFIGURATION", (Object[])new Object[0]));
        }
    }

    @Override
    public void eagerInitialize() {
        this.handlerClass = this.getHandlerClass();
    }
}

