/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.Constants;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.utils.UUIDGenerator;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.extensions.addressing.AddressingPropertiesImpl;
import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.extensions.policy.PolicyScopeLevel;
import org.jboss.ws.extensions.policy.metadata.PolicyMetaExtension;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.MetaDataExtension;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingFault;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLDocumentation;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLImport;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.w3c.dom.Element;

public abstract class WSDLGenerator {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSDLGenerator.class);
    private static final AddressingProperties WSA_PROPERTIES = new AddressingPropertiesImpl();
    public static final String WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final String WSAM_NS = "http://www.w3.org/2007/05/addressing/metadata";
    public static final String WSP_NS = "http://www.w3.org/ns/ws-policy";
    protected WSDLDefinitions wsdl;
    protected boolean extension;
    protected Map<String, String> packageNamespaceMap = new HashMap<String, String>();

    protected abstract void processTypes();

    protected void processEndpoint(WSDLService service, EndpointMetaData endpoint) {
        WSDLEndpoint wsdlEndpoint = new WSDLEndpoint(service, endpoint.getPortName());
        String address = endpoint.getEndpointAddress();
        wsdlEndpoint.setAddress(address == null ? "REPLACE_WITH_ACTUAL_URL" : address);
        service.addEndpoint(wsdlEndpoint);
        QName interfaceQName = endpoint.getPortTypeName();
        WSDLInterface wsdlInterface = new WSDLInterface(this.wsdl, interfaceQName);
        this.wsdl.addInterface(wsdlInterface);
        if (!interfaceQName.getNamespaceURI().equals(endpoint.getServiceMetaData().getServiceName().getNamespaceURI())) {
            WSDLImport wsdlImport = new WSDLImport(this.wsdl);
            wsdlImport.setLocation(interfaceQName.getLocalPart() + "_PortType");
            wsdlImport.setNamespace(interfaceQName.getNamespaceURI());
            this.wsdl.addImport(wsdlImport);
            this.wsdl.registerNamespaceURI(interfaceQName.getNamespaceURI(), null);
        }
        QName bindingQName = new QName(interfaceQName.getNamespaceURI(), interfaceQName.getLocalPart() + "Binding");
        WSDLBinding wsdlBinding = new WSDLBinding(this.wsdl, bindingQName);
        wsdlBinding.setInterfaceName(interfaceQName);
        if (this.extension) {
            endpoint.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        }
        wsdlBinding.setType(endpoint.getBindingId());
        this.wsdl.addBinding(wsdlBinding);
        wsdlEndpoint.setBinding(bindingQName);
        if (endpoint.isFeatureEnabled(AddressingFeature.class) && this.wsdl.getPrefix(WSAM_NS) == null) {
            this.wsdl.registerNamespaceURI(WSAM_NS, "wsa");
        }
        if (endpoint.getDocumentation() != null) {
            String prefix = this.wsdl.getPrefix("http://java.sun.com/xml/ns/jaxws");
            if (prefix == null) {
                prefix = "jaxws";
                this.wsdl.registerNamespaceURI("http://java.sun.com/xml/ns/jaxws", prefix);
            }
            Element javadocElement = DOMUtils.createElement((String)Constants.WSDL_ELEMENT_JAXWS_JAVADOC.getLocalPart(), (String)prefix);
            javadocElement.setTextContent(endpoint.getDocumentation());
            Element classElement = DOMUtils.createElement((String)Constants.WSDL_ELEMENT_JAXWS_CLASS.getLocalPart(), (String)prefix);
            classElement.setAttribute("name", interfaceQName.getLocalPart());
            classElement.appendChild(javadocElement);
            Element bindingsElement = DOMUtils.createElement((String)Constants.WSDL_ELEMENT_JAXWS_BINDINGS.getLocalPart(), (String)prefix);
            bindingsElement.appendChild(classElement);
            WSDLExtensibilityElement ext = new WSDLExtensibilityElement("http://java.sun.com/xml/ns/jaxws", bindingsElement);
            wsdlInterface.addExtensibilityElement(ext);
            wsdlInterface.setDocumentationElement(new WSDLDocumentation(endpoint.getDocumentation()));
        }
        for (OperationMetaData operation : endpoint.getOperations()) {
            this.processOperation(wsdlInterface, wsdlBinding, operation);
        }
        MetaDataExtension ext = endpoint.getExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (ext != null) {
            PolicyMetaExtension policyExt = (PolicyMetaExtension)ext;
            for (Policy policy : policyExt.getPolicies(PolicyScopeLevel.WSDL_PORT)) {
                this.addPolicyDefinition(policy);
                this.addPolicyReference(policy, wsdlEndpoint);
            }
            for (Policy policy : policyExt.getPolicies(PolicyScopeLevel.WSDL_PORT_TYPE)) {
                this.addPolicyDefinition(policy);
                this.addPolicyURIAttribute(policy, wsdlInterface);
            }
            for (Policy policy : policyExt.getPolicies(PolicyScopeLevel.WSDL_BINDING)) {
                this.addPolicyDefinition(policy);
                this.addPolicyReference(policy, wsdlBinding);
            }
        }
        if (endpoint.isFeatureEnabled(AddressingFeature.class)) {
            AddressingFeature addressingFeature = endpoint.getFeature(AddressingFeature.class);
            String policyId = this.addAddressingPolicyDefinition(addressingFeature);
            this.addAddressingPolicyReference(policyId, wsdlBinding);
        }
    }

    protected void addPolicyDefinition(Policy policy) {
        try {
            PolicyWriter writer = PolicyFactory.getPolicyWriter((int)2);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            writer.writePolicy(policy, (OutputStream)outputStream);
            Element element = DOMUtils.parse((String)outputStream.toString("UTF-8"));
            WSDLExtensibilityElement ext = new WSDLExtensibilityElement("http://www.jboss.org/jbossws/wsp/policy", element);
            this.wsdl.addExtensibilityElement(ext);
            if (this.wsdl.getPrefix(element.getNamespaceURI()) == null) {
                this.wsdl.registerNamespaceURI(element.getNamespaceURI(), element.getPrefix());
            }
        }
        catch (IOException ioe) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_WHILE_CONVERTING_POLICY_TO_ELEMENT", (Object[])new Object[0]));
        }
    }

    private String addAddressingPolicyDefinition(AddressingFeature addressing) {
        String policyId = UUIDGenerator.generateRandomUUIDString();
        Element policyElement = DOMUtils.createElement((QName)new QName(WSP_NS, "Policy", "wsp"));
        policyElement.setAttribute("xmlns:wsu", WSU_NS);
        policyElement.setAttribute("xmlns:wsp", WSP_NS);
        policyElement.setAttribute("wsu:Id", policyId);
        Element addressingElement = DOMUtils.createElement((QName)new QName(WSAM_NS, "Addressing", "wsam"));
        addressingElement.setAttribute("xmlns:wsam", WSAM_NS);
        policyElement.appendChild(addressingElement);
        if (!addressing.isRequired()) {
            addressingElement.setAttributeNS(WSP_NS, "wsp:Optional", "true");
        }
        Element nestedPolicyElement = DOMUtils.createElement((QName)new QName(WSP_NS, "Policy", "wsp"));
        addressingElement.appendChild(nestedPolicyElement);
        if (addressing.getResponses() == AddressingFeature.Responses.ANONYMOUS) {
            Element anonymousResponsesElement = DOMUtils.createElement((QName)new QName(WSAM_NS, "AnonymousResponses", "wsam"));
            nestedPolicyElement.appendChild(anonymousResponsesElement);
        } else if (addressing.getResponses() == AddressingFeature.Responses.NON_ANONYMOUS) {
            Element anonymousResponsesElement = DOMUtils.createElement((QName)new QName(WSAM_NS, "NonAnonymousResponses", "wsam"));
            nestedPolicyElement.appendChild(anonymousResponsesElement);
        }
        this.wsdl.addExtensibilityElement(new WSDLExtensibilityElement(WSP_NS, policyElement));
        return policyId;
    }

    protected void addPolicyReference(Policy policy, Extendable extendable) {
        QName policyRefQName = Constants.WSDL_ELEMENT_WSP_POLICYREFERENCE;
        String prefix = this.wsdl.getPrefix(policyRefQName.getNamespaceURI());
        if (prefix == null) {
            prefix = "wsp";
            this.wsdl.registerNamespaceURI(policyRefQName.getNamespaceURI(), prefix);
        }
        Element element = DOMUtils.createElement((String)policyRefQName.getLocalPart(), (String)prefix);
        element.setAttribute("URI", policy.getPolicyURI());
        WSDLExtensibilityElement ext = new WSDLExtensibilityElement("http://www.jboss.org/jbossws/wsp/policyReference", element);
        extendable.addExtensibilityElement(ext);
    }

    protected void addAddressingPolicyReference(String policyId, Extendable extendable) {
        Element policyReferenceElement = DOMUtils.createElement((QName)new QName(WSP_NS, "PolicyReference", "wsp"));
        policyReferenceElement.setAttribute("xmlns:wsp", WSP_NS);
        policyReferenceElement.setAttribute("URI", "#" + policyId);
        extendable.addExtensibilityElement(new WSDLExtensibilityElement(WSP_NS, policyReferenceElement));
    }

    protected void addPolicyURIAttribute(Policy policy, Extendable extendable) {
        WSDLProperty prop = extendable.getProperty("http://www.jboss.org/jbossws/wsp/policyURIs");
        if (prop == null) {
            extendable.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsp/policyURIs", policy.getPolicyURI()));
        } else {
            prop.setValue(prop.getValue() + "," + policy.getPolicyURI());
        }
    }

    protected void processOperation(WSDLInterface wsdlInterface, WSDLBinding wsdlBinding, OperationMetaData operation) {
        WSDLInterfaceOperation interfaceOperation = new WSDLInterfaceOperation(wsdlInterface, operation.getQName());
        WSDLBindingOperation bindingOperation = new WSDLBindingOperation(wsdlBinding);
        interfaceOperation.setPattern(operation.isOneWay() ? "http://www.w3.org/2004/08/wsdl/in-only" : "http://www.w3.org/2004/08/wsdl/in-out");
        bindingOperation.setRef(operation.getQName());
        bindingOperation.setSOAPAction(operation.getSOAPAction());
        if (operation.getStyle() == Style.DOCUMENT) {
            this.processOperationDOC(interfaceOperation, bindingOperation, operation);
        } else {
            this.processOperationRPC(interfaceOperation, bindingOperation, operation);
        }
        for (FaultMetaData fault : operation.getFaults()) {
            QName faultName = new QName(operation.getQName().getNamespaceURI(), fault.getXmlName().getLocalPart());
            WSDLInterfaceFault interfaceFault = new WSDLInterfaceFault(wsdlInterface, faultName);
            interfaceFault.setElement(fault.getXmlName());
            wsdlInterface.addFault(interfaceFault);
            WSDLInterfaceOperationOutfault outfault = new WSDLInterfaceOperationOutfault(interfaceOperation);
            String ns = this.getNamespace(fault.getJavaType(), fault.getXmlName().getNamespaceURI());
            QName outFaultName = new QName(ns, fault.getXmlName().getLocalPart());
            outfault.setRef(outFaultName);
            this.setAddressingAction(outfault, fault, operation);
            interfaceOperation.addOutfault(outfault);
            WSDLBindingFault bindingFault = new WSDLBindingFault(wsdlBinding);
            bindingFault.setRef(faultName);
            wsdlBinding.addFault(bindingFault);
        }
        if (operation.getDocumentation() != null) {
            String prefix = this.wsdl.getPrefix("http://java.sun.com/xml/ns/jaxws");
            if (prefix == null) {
                prefix = "jaxws";
                this.wsdl.registerNamespaceURI("http://java.sun.com/xml/ns/jaxws", prefix);
            }
            Element javadocElement = DOMUtils.createElement((String)Constants.WSDL_ELEMENT_JAXWS_JAVADOC.getLocalPart(), (String)prefix);
            javadocElement.setTextContent(operation.getDocumentation());
            Element methodElement = DOMUtils.createElement((String)Constants.WSDL_ELEMENT_JAXWS_METHOD.getLocalPart(), (String)prefix);
            methodElement.setAttribute("name", operation.getQName().getLocalPart());
            methodElement.appendChild(javadocElement);
            Element bindingsElement = DOMUtils.createElement((String)Constants.WSDL_ELEMENT_JAXWS_BINDINGS.getLocalPart(), (String)prefix);
            bindingsElement.appendChild(methodElement);
            WSDLExtensibilityElement ext = new WSDLExtensibilityElement("http://java.sun.com/xml/ns/jaxws", bindingsElement);
            interfaceOperation.addExtensibilityElement(ext);
            interfaceOperation.setDocumentationElement(new WSDLDocumentation(operation.getDocumentation()));
        }
        wsdlInterface.addOperation(interfaceOperation);
        wsdlBinding.addOperation(bindingOperation);
    }

    protected void addSignatureItem(WSDLInterfaceOperation operation, ParameterMetaData param, boolean isReturn) {
        WSDLRPCSignatureItem.Direction direction = isReturn ? WSDLRPCSignatureItem.Direction.RETURN : (param.getMode() == ParameterMode.INOUT ? WSDLRPCSignatureItem.Direction.INOUT : (param.getMode() == ParameterMode.OUT ? WSDLRPCSignatureItem.Direction.OUT : WSDLRPCSignatureItem.Direction.IN));
        operation.addRpcSignatureItem(new WSDLRPCSignatureItem(param.getPartName(), direction));
    }

    protected void processOperationDOC(WSDLInterfaceOperation interfaceOperation, WSDLBindingOperation bindingOperation, OperationMetaData operation) {
        boolean twoWay;
        interfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/iri");
        WSDLInterfaceOperationInput input = new WSDLInterfaceOperationInput(interfaceOperation);
        WSDLBindingOperationInput bindingInput = new WSDLBindingOperationInput(bindingOperation);
        WSDLInterfaceOperationOutput output = null;
        WSDLBindingOperationOutput bindingOutput = null;
        boolean bl = twoWay = !operation.isOneWay();
        if (twoWay) {
            output = new WSDLInterfaceOperationOutput(interfaceOperation);
            bindingOutput = new WSDLBindingOperationOutput(bindingOperation);
            ParameterMetaData returnParameter = operation.getReturnParameter();
            if (returnParameter != null) {
                QName xmlName = returnParameter.getXmlName();
                String partName = returnParameter.getPartName();
                if (returnParameter.isInHeader()) {
                    WSDLSOAPHeader header = new WSDLSOAPHeader(xmlName, partName);
                    header.setIncludeInSignature(true);
                    bindingOutput.addSoapHeader(header);
                } else {
                    output.setElement(xmlName);
                    output.setPartName(partName);
                }
                this.addSignatureItem(interfaceOperation, returnParameter, true);
            }
            interfaceOperation.addOutput(output);
            this.setAddressingAction(output, operation);
            bindingOperation.addOutput(bindingOutput);
        }
        for (ParameterMetaData param : operation.getParameters()) {
            if (param.isInHeader()) {
                WSDLSOAPHeader header = new WSDLSOAPHeader(param.getXmlName(), param.getPartName());
                header.setIncludeInSignature(true);
                if (param.getMode() != ParameterMode.OUT) {
                    bindingInput.addSoapHeader(header);
                }
                if (twoWay && param.getMode() != ParameterMode.IN) {
                    bindingOutput.addSoapHeader(header);
                }
            } else {
                if (param.getMode() != ParameterMode.OUT) {
                    input.setElement(param.getXmlName());
                    input.setPartName(param.getPartName());
                }
                if (twoWay && param.getMode() != ParameterMode.IN) {
                    output.setElement(param.getXmlName());
                    output.setPartName(param.getPartName());
                }
            }
            this.addSignatureItem(interfaceOperation, param, false);
        }
        interfaceOperation.addInput(input);
        this.setAddressingAction(input, operation);
        bindingOperation.addInput(bindingInput);
    }

    protected void processOperationRPC(WSDLInterfaceOperation interfaceOperation, WSDLBindingOperation bindingOperation, OperationMetaData operation) {
        boolean twoWay;
        interfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/rpc");
        WSDLInterfaceOperationInput input = new WSDLInterfaceOperationInput(interfaceOperation);
        WSDLBindingOperationInput bindingInput = new WSDLBindingOperationInput(bindingOperation);
        QName operationName = operation.getQName();
        input.setElement(operationName);
        WSDLInterfaceOperationOutput output = null;
        WSDLBindingOperationOutput bindingOutput = null;
        boolean bl = twoWay = !operation.isOneWay();
        if (twoWay) {
            output = new WSDLInterfaceOperationOutput(interfaceOperation);
            bindingOutput = new WSDLBindingOperationOutput(bindingOperation);
            output.setElement(new QName(operationName.getNamespaceURI(), operationName.getLocalPart() + "Response"));
            ParameterMetaData returnParameter = operation.getReturnParameter();
            if (returnParameter != null) {
                QName xmlName = returnParameter.getXmlName();
                String partName = returnParameter.getPartName();
                if (returnParameter.isInHeader()) {
                    WSDLSOAPHeader header = new WSDLSOAPHeader(xmlName, partName);
                    header.setIncludeInSignature(true);
                    bindingOutput.addSoapHeader(header);
                } else {
                    QName xmlType = returnParameter.getXmlType();
                    String ns = this.getNamespace(returnParameter.getJavaType(), xmlType.getNamespaceURI());
                    QName newXmlType = new QName(ns, xmlType.getLocalPart());
                    WSDLRPCPart part = new WSDLRPCPart(partName, newXmlType);
                    output.addChildPart(part);
                }
                this.addSignatureItem(interfaceOperation, returnParameter, true);
            }
            interfaceOperation.addOutput(output);
            this.setAddressingAction(output, operation);
            bindingOperation.addOutput(bindingOutput);
        }
        for (ParameterMetaData param : operation.getParameters()) {
            if (param.isInHeader()) {
                WSDLSOAPHeader header = new WSDLSOAPHeader(param.getXmlName(), param.getPartName());
                header.setIncludeInSignature(true);
                if (param.getMode() != ParameterMode.OUT) {
                    bindingInput.addSoapHeader(header);
                }
                if (twoWay && param.getMode() != ParameterMode.IN) {
                    bindingOutput.addSoapHeader(header);
                }
            } else {
                QName xmlType = param.getXmlType();
                String ns = this.getNamespace(param.getJavaType(), xmlType.getNamespaceURI());
                QName newXmlType = new QName(ns, xmlType.getLocalPart());
                WSDLRPCPart part = new WSDLRPCPart(param.getPartName(), newXmlType);
                if (param.getMode() != ParameterMode.OUT) {
                    input.addChildPart(part);
                }
                if (twoWay && param.getMode() != ParameterMode.IN) {
                    output.addChildPart(part);
                }
            }
            this.addSignatureItem(interfaceOperation, param, false);
        }
        interfaceOperation.addInput(input);
        this.setAddressingAction(input, operation);
        bindingOperation.addInput(bindingInput);
    }

    private void setAddressingAction(WSDLInterfaceOperationInput input, OperationMetaData operationMD) {
        AddressingOpMetaExt addrExt = this.getAddressingMD(operationMD);
        if (addrExt != null) {
            input.setAction(addrExt.getInboundAction());
        }
    }

    private void setAddressingAction(WSDLInterfaceOperationOutput output, OperationMetaData operationMD) {
        AddressingOpMetaExt addrExt = this.getAddressingMD(operationMD);
        if (addrExt != null) {
            output.setAction(addrExt.getOutboundAction());
        }
    }

    private void setAddressingAction(WSDLInterfaceOperationOutfault fault, FaultMetaData faultMD, OperationMetaData operationMD) {
        AddressingOpMetaExt addrExt = this.getAddressingMD(operationMD);
        if (addrExt != null) {
            fault.setAction(addrExt.getFaultAction(faultMD.getXmlName()));
        }
    }

    private AddressingOpMetaExt getAddressingMD(OperationMetaData operationMD) {
        if (operationMD.getEndpointMetaData().isFeatureEnabled(AddressingFeature.class)) {
            return (AddressingOpMetaExt)operationMD.getExtension(WSA_PROPERTIES.getNamespaceURI());
        }
        return null;
    }

    protected void processService(ServiceMetaData service) {
        WSDLService wsdlService = new WSDLService(this.wsdl, service.getServiceName());
        this.wsdl.addService(wsdlService);
        EndpointMetaData endpoint2 = null;
        for (EndpointMetaData endpoint2 : service.getEndpoints()) {
            this.processEndpoint(wsdlService, endpoint2);
        }
        if (endpoint2 == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"A_SERVICE_MUST_HAVE_AN_ENDPOINT", (Object[])new Object[0]));
        }
        wsdlService.setInterfaceName(endpoint2.getPortName());
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public WSDLDefinitions generate(ServiceMetaData service) {
        String soapURI;
        this.wsdl = new WSDLDefinitions();
        this.wsdl.setWsdlNamespace("http://schemas.xmlsoap.org/wsdl/");
        String ns = service.getServiceName().getNamespaceURI();
        this.wsdl.setTargetNamespace(ns);
        this.wsdl.registerNamespaceURI(ns, "tns");
        this.wsdl.registerNamespaceURI("http://www.w3.org/2001/XMLSchema", "xsd");
        if (this.packageNamespaceMap != null) {
            Set<String> keys = this.packageNamespaceMap.keySet();
            Iterator<String> iter = keys.iterator();
            while (iter != null && iter.hasNext()) {
                String pkg = iter.next();
                this.wsdl.registerNamespaceURI(this.packageNamespaceMap.get(pkg), null);
            }
        }
        String soapPrefix = this.extension ? "soap12" : null;
        String string = soapURI = this.extension ? "http://schemas.xmlsoap.org/wsdl/soap12/" : null;
        if (!this.extension) {
            for (EndpointMetaData ep : service.getEndpoints()) {
                String bindingId = ep.getBindingId();
                if (bindingId.startsWith("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                    soapPrefix = "soap";
                    soapURI = "http://schemas.xmlsoap.org/wsdl/soap/";
                    continue;
                }
                if (!bindingId.startsWith("http://www.w3.org/2003/05/soap/bindings/HTTP/")) continue;
                soapPrefix = "soap12";
                soapURI = "http://schemas.xmlsoap.org/wsdl/soap12/";
            }
        }
        if (soapURI != null && soapPrefix != null) {
            this.wsdl.registerNamespaceURI(soapURI, soapPrefix);
        }
        this.processTypes();
        this.processService(service);
        return this.wsdl;
    }

    protected String getNamespace(String packageName, String defaultNS) {
        String ns;
        String retNS = defaultNS;
        if (this.packageNamespaceMap != null && (ns = this.packageNamespaceMap.get(packageName)) != null) {
            retNS = ns;
        }
        return retNS;
    }

    protected String getNamespace(String packageName) {
        return this.getNamespace(packageName, this.wsdl.getTargetNamespace());
    }

    protected String getNamespace(Class type, String defaultNS) {
        while (type.isArray()) {
            type = type.getComponentType();
        }
        Package pkg = type.getPackage();
        String pkgName = null;
        if (pkg != null) {
            pkgName = pkg.getName();
        }
        return this.getNamespace(pkgName, defaultNS);
    }

    protected String getJustPackageName(String classname) {
        int index = classname.lastIndexOf(".");
        if (index < 0) {
            index = classname.length();
        }
        return classname.substring(0, index);
    }
}

