/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.ejb3.remote.LocalEjbReceiver;
import org.jboss.as.ejb3.remote.TCCLEJBClientContextSelector;
import org.jboss.as.ejb3.remote.TCCLEJBClientContextSelectorService;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DefaultEjbClientContextService
implements Service<EJBClientContext> {
    private static final Logger logger = Logger.getLogger(DefaultEjbClientContextService.class);
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "ejbClientContext"});
    public static final ServiceName DEFAULT_SERVICE_NAME = BASE_SERVICE_NAME.append(new String[]{"default"});
    private final InjectedValue<TCCLEJBClientContextSelectorService> tcclEJBClientContextSelector = new InjectedValue();
    private final InjectedValue<LocalEjbReceiver> defaultLocalEJBReceiver = new InjectedValue();
    private volatile EJBClientContext context;
    private final boolean lockSelectorOnStart;

    public DefaultEjbClientContextService(boolean lockEJBClientContextSelectorOnStart) {
        this.lockSelectorOnStart = lockEJBClientContextSelectorOnStart;
    }

    public synchronized void start(StartContext context) throws StartException {
        EJBClientContext clientContext = EJBClientContext.create();
        LocalEjbReceiver localEjbReceiver = (LocalEjbReceiver)((Object)this.defaultLocalEJBReceiver.getOptionalValue());
        if (localEjbReceiver != null) {
            clientContext.registerEJBReceiver((EJBReceiver)localEjbReceiver);
        }
        this.context = clientContext;
        if (this.lockSelectorOnStart) {
            AccessController.doPrivileged(new LockSelectorAction());
        }
        TCCLEJBClientContextSelector.INSTANCE.setTCCLEJBClientContextService((TCCLEJBClientContextSelectorService)this.tcclEJBClientContextSelector.getValue());
    }

    public synchronized void stop(StopContext context) {
        this.context = null;
        TCCLEJBClientContextSelector.INSTANCE.setTCCLEJBClientContextService(null);
    }

    public EJBClientContext getValue() throws IllegalStateException, IllegalArgumentException {
        return this.context;
    }

    public Injector<TCCLEJBClientContextSelectorService> getTCCLBasedEJBClientContextSelectorInjector() {
        return this.tcclEJBClientContextSelector;
    }

    public Injector<LocalEjbReceiver> getDefaultLocalEJBReceiverInjector() {
        return this.defaultLocalEJBReceiver;
    }

    static {
        AccessController.doPrivileged(new SetSelectorAction(TCCLEJBClientContextSelector.INSTANCE));
    }

    private static final class LockSelectorAction
    implements PrivilegedAction<Void> {
        private LockSelectorAction() {
        }

        @Override
        public Void run() {
            EJBClientContext.lockSelector();
            return null;
        }
    }

    private static final class SetSelectorAction
    implements PrivilegedAction<ContextSelector<EJBClientContext>> {
        private final ContextSelector<EJBClientContext> selector;

        private SetSelectorAction(ContextSelector<EJBClientContext> selector) {
            this.selector = selector;
        }

        @Override
        public ContextSelector<EJBClientContext> run() {
            return EJBClientContext.setSelector(this.selector);
        }
    }
}

