/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContextAssociation;

public abstract class CascadeDeleteStrategy {
    protected final JDBCCMRFieldBridge cmrField;
    protected final JDBCEntityBridge entity;
    protected final JDBCStoreManager relatedManager;
    protected final Logger log;

    public static CascadeDeleteStrategy getCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) {
        JDBCRelationshipRoleMetaData relatedRole = cmrField.getMetaData().getRelatedRole();
        CascadeDeleteStrategy result = relatedRole.isBatchCascadeDelete() ? new BatchCascadeDeleteStrategy(cmrField) : (relatedRole.isCascadeDelete() ? new DefaultCascadeDeleteStrategy(cmrField) : new NoneCascadeDeleteStrategy(cmrField));
        return result;
    }

    public CascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) {
        this.cmrField = cmrField;
        this.entity = (JDBCEntityBridge)cmrField.getEntity();
        this.relatedManager = cmrField.getRelatedManager();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + cmrField.getEntity().getEntityName()));
    }

    public abstract void removedIds(CmpEntityBeanContext var1, Object[] var2, List var3);

    public abstract void cascadeDelete(CmpEntityBeanContext var1, List var2) throws RemoveException, RemoteException;

    protected void scheduleCascadeDelete(Object[] oldRelationsRef, List values) {
        HashMap<JDBCCMRFieldBridge, List> oldRelations = (HashMap<JDBCCMRFieldBridge, List>)oldRelationsRef[0];
        if (oldRelations == null) {
            oldRelationsRef[0] = oldRelations = new HashMap<JDBCCMRFieldBridge, List>();
        }
        oldRelations.put(this.cmrField, values);
        this.relatedManager.scheduleCascadeDelete(values);
    }

    protected void executeDeleteSQL(String sql, Object key) throws RemoveException {
        Connection con = null;
        PreparedStatement ps = null;
        int rowsAffected = 0;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Executing SQL: " + sql));
            }
            con = this.entity.getDataSource().getConnection();
            ps = con.prepareStatement(sql);
            this.entity.setPrimaryKeyParameters(ps, 1, key);
            rowsAffected = ps.executeUpdate();
        }
        catch (Exception e) {
            try {
                this.log.error((Object)("Could not remove " + key), (Throwable)e);
                throw new RemoveException("Could not remove " + key);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        if (rowsAffected == 0) {
            this.log.error((Object)("Could not remove entity " + key));
            throw new RemoveException("Could not remove entity");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Remove: Rows affected = " + rowsAffected));
        }
    }

    public void invokeRemoveRelated(Object relatedId) throws RemoveException, RemoteException {
        CmpEntityBeanComponent component = this.relatedManager.getComponent();
        if (component.getLocalClass() != null) {
            EJBLocalObject ejbObject = component.getEJBLocalObject(relatedId);
            ejbObject.remove();
        } else {
            EJBObject ejbObject = component.getEJBObject(relatedId);
            ejbObject.remove();
        }
    }

    static interface SecurityActions {
        public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

            @Override
            public Principal getPrincipal() {
                return SecurityContextAssociation.getPrincipal();
            }

            @Override
            public Object getCredential() {
                return SecurityContextAssociation.getCredential();
            }
        };
        public static final SecurityActions PRIVILEGED = new SecurityActions(){
            private final PrivilegedAction getPrincipalAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityContextAssociation.getPrincipal();
                }
            };
            private final PrivilegedAction getCredentialAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityContextAssociation.getCredential();
                }
            };

            @Override
            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
            }

            @Override
            public Object getCredential() {
                return AccessController.doPrivileged(this.getCredentialAction);
            }
        };

        public Principal getPrincipal();

        public Object getCredential();

        public static class UTIL {
            static SecurityActions getSecurityActions() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }
        }
    }

    public static final class BatchCascadeDeleteStrategy
    extends CascadeDeleteStrategy {
        private final String batchCascadeDeleteSql;

        public BatchCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) {
            super(cmrField);
            if (cmrField.hasForeignKey()) {
                throw new RuntimeException("Batch cascade-delete was setup for the role with a foreign key: relationship " + cmrField.getMetaData().getRelationMetaData().getRelationName() + ", role " + cmrField.getMetaData().getRelationshipRoleName() + ". Batch cascade-delete supported only for roles with no foreign keys.");
            }
            StringBuffer buf = new StringBuffer(100);
            buf.append("DELETE FROM ").append(cmrField.getRelatedJDBCEntity().getQualifiedTableName()).append(" WHERE ");
            SQLUtil.getWhereClause(cmrField.getRelatedCMRField().getForeignKeyFields(), buf);
            this.batchCascadeDeleteSql = buf.toString();
            this.log.debug((Object)(cmrField.getMetaData().getRelationMetaData().getRelationName() + " batch cascade delete SQL: " + this.batchCascadeDeleteSql));
        }

        @Override
        public void removedIds(CmpEntityBeanContext ctx, Object[] oldRelationRefs, List ids) {
            this.cmrField.scheduleChildrenForBatchCascadeDelete(ctx);
            this.scheduleCascadeDelete(oldRelationRefs, new ArrayList(ids));
        }

        @Override
        public void cascadeDelete(CmpEntityBeanContext ctx, List oldValues) throws RemoveException, RemoteException {
            boolean didDelete = false;
            boolean trace = this.log.isTraceEnabled();
            for (int i = 0; i < oldValues.size(); ++i) {
                Object oldValue = oldValues.get(i);
                if (this.relatedManager.unscheduledCascadeDelete(oldValue)) {
                    if (trace) {
                        this.log.trace((Object)("Removing " + oldValue));
                    }
                    this.invokeRemoveRelated(oldValue);
                    didDelete = true;
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)(oldValue + " already removed"));
            }
            if (didDelete) {
                this.executeDeleteSQL(this.batchCascadeDeleteSql, ctx.getPrimaryKey());
            }
        }
    }

    public static final class DefaultCascadeDeleteStrategy
    extends CascadeDeleteStrategy {
        public DefaultCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) {
            super(cmrField);
        }

        @Override
        public void removedIds(CmpEntityBeanContext ctx, Object[] oldRelationRef, List ids) {
            this.cmrField.scheduleChildrenForCascadeDelete(ctx);
            this.scheduleCascadeDelete(oldRelationRef, new ArrayList(ids));
            this.cmrField.setInstanceValue(ctx, null);
        }

        @Override
        public void cascadeDelete(CmpEntityBeanContext ctx, List oldValues) throws RemoveException, RemoteException {
            boolean trace = this.log.isTraceEnabled();
            for (int i = 0; i < oldValues.size(); ++i) {
                Object oldValue = oldValues.get(i);
                if (this.relatedManager.unscheduledCascadeDelete(oldValue)) {
                    if (trace) {
                        this.log.trace((Object)("Removing " + oldValue));
                    }
                    this.invokeRemoveRelated(oldValue);
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)(oldValue + " already removed"));
            }
        }
    }

    public static final class NoneCascadeDeleteStrategy
    extends CascadeDeleteStrategy {
        public NoneCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) {
            super(cmrField);
        }

        @Override
        public void removedIds(CmpEntityBeanContext ctx, Object[] oldRelationRefs, List ids) {
            this.cmrField.setInstanceValue(ctx, null);
        }

        @Override
        public void cascadeDelete(CmpEntityBeanContext ctx, List oldValues) throws RemoveException, RemoteException {
            boolean trace = this.log.isTraceEnabled();
            for (int i = 0; i < oldValues.size(); ++i) {
                Object oldValue = oldValues.get(i);
                if (this.relatedManager.unscheduledCascadeDelete(oldValue)) {
                    if (trace) {
                        this.log.trace((Object)("Removing " + oldValue));
                    }
                    this.invokeRemoveRelated(oldValue);
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)(oldValue + " already removed"));
            }
        }
    }
}

