/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.SecurityLogger;
import org.jboss.as.security.plugins.JNDIBasedSecurityManagement;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.security.ISecurityManagement;

public class SecurityManagementService
implements Service<ISecurityManagement> {
    public static final ServiceName SERVICE_NAME = SecurityExtension.JBOSS_SECURITY.append(new String[]{"security-management"});
    private static final SecurityLogger log = SecurityLogger.ROOT_LOGGER;
    private final String authenticationManagerClassName;
    private final boolean deepCopySubjectMode;
    private final String callbackHandlerClassName;
    private final String authorizationManagerClassName;
    private final String auditManagerClassName;
    private final String identityTrustManagerClassName;
    private final String mappingManagerClassName;
    private volatile ISecurityManagement securityManagement;

    public SecurityManagementService(String authenticationManagerClassName, boolean deepCopySubjectMode, String callbackHandlerClassName, String authorizationManagerClassName, String auditManagerClassName, String identityTrustManagerClassName, String mappingManagerClassName) {
        this.authenticationManagerClassName = authenticationManagerClassName;
        this.deepCopySubjectMode = deepCopySubjectMode;
        this.callbackHandlerClassName = callbackHandlerClassName;
        this.authorizationManagerClassName = authorizationManagerClassName;
        this.auditManagerClassName = auditManagerClassName;
        this.identityTrustManagerClassName = identityTrustManagerClassName;
        this.mappingManagerClassName = mappingManagerClassName;
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting SecurityManagementService", new Object[0]);
        JNDIBasedSecurityManagement securityManagement = new JNDIBasedSecurityManagement();
        securityManagement.setAuthenticationManagerClassName(this.authenticationManagerClassName);
        securityManagement.setDeepCopySubjectMode(this.deepCopySubjectMode);
        securityManagement.setCallbackHandlerClassName(this.callbackHandlerClassName);
        securityManagement.setAuthorizationManagerClassName(this.authorizationManagerClassName);
        securityManagement.setAuditManagerClassName(this.auditManagerClassName);
        securityManagement.setIdentityTrustManagerClassName(this.identityTrustManagerClassName);
        securityManagement.setMappingManagerClassName(this.mappingManagerClassName);
        this.securityManagement = securityManagement;
    }

    public void stop(StopContext context) {
    }

    public ISecurityManagement getValue() throws IllegalStateException {
        return this.securityManagement;
    }
}

