/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.jpa.container.ReferenceCountedEntityManager;

public class SFSBCallStack {
    private static ThreadLocal<ArrayList<Map<String, ReferenceCountedEntityManager>>> SFSBInvocationStack = new ThreadLocal<ArrayList<Map<String, ReferenceCountedEntityManager>>>(){

        @Override
        protected ArrayList<Map<String, ReferenceCountedEntityManager>> initialValue() {
            return new ArrayList<Map<String, ReferenceCountedEntityManager>>();
        }
    };
    private static ThreadLocal<Map<String, ReferenceCountedEntityManager>> sfsbCreationMap = new ThreadLocal();
    private static ThreadLocal<Integer> sfsbCreationCallStackCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public static void beginSfsbCreation() {
        int no = sfsbCreationCallStackCount.get();
        if (no == 0) {
            sfsbCreationMap.set(new HashMap());
        }
        sfsbCreationCallStackCount.set(no + 1);
    }

    public static void endSfsbCreation() {
        int no = sfsbCreationCallStackCount.get();
        sfsbCreationCallStackCount.set(--no);
        if (no == 0) {
            sfsbCreationMap.remove();
        }
    }

    public static void extendedPersistenceContextCreated(String scopedPuName, ReferenceCountedEntityManager entityManager) {
        Map<String, ReferenceCountedEntityManager> map;
        if (sfsbCreationCallStackCount.get() > 0 && !(map = sfsbCreationMap.get()).containsKey(scopedPuName)) {
            map.put(scopedPuName, entityManager);
        }
    }

    public static ReferenceCountedEntityManager findPersistenceContext(String puScopedName) {
        for (Map<String, ReferenceCountedEntityManager> handle : SFSBCallStack.currentSFSBCallStack()) {
            ReferenceCountedEntityManager res = handle.get(puScopedName);
            if (res == null) continue;
            return res;
        }
        Map<String, ReferenceCountedEntityManager> map = sfsbCreationMap.get();
        if (map != null) {
            return map.get(puScopedName);
        }
        return null;
    }

    public static ArrayList<Map<String, ReferenceCountedEntityManager>> currentSFSBCallStack() {
        return SFSBInvocationStack.get();
    }

    public static void pushCall(Map<String, ReferenceCountedEntityManager> entityManagers) {
        SFSBCallStack.currentSFSBCallStack().add(entityManagers);
    }

    public static Map<String, ReferenceCountedEntityManager> popCall() {
        ArrayList<Map<String, ReferenceCountedEntityManager>> stack = SFSBCallStack.currentSFSBCallStack();
        Map<String, ReferenceCountedEntityManager> result = stack.remove(stack.size() - 1);
        stack.trimToSize();
        return result;
    }
}

